/*
 * Decompiled with CFR 0.152.
 */
package pl.project13.scala.jmh.extras.profiler;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.management.ManagementFactory;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.openjdk.jmh.infra.BenchmarkParams;
import org.openjdk.jmh.profile.ExternalProfiler;
import org.openjdk.jmh.results.AggregationPolicy;
import org.openjdk.jmh.results.Aggregator;
import org.openjdk.jmh.results.BenchmarkResult;
import org.openjdk.jmh.results.Result;
import org.openjdk.jmh.results.ResultRole;
import org.openjdk.jmh.util.FileUtils;

public class FlightRecordingProfiler
implements ExternalProfiler {
    private String startFlightRecordingOptions = "duration=120s,name=profile,settings=profile,";
    private String flightRecorderOptions = "samplethreads=true,stackdepth=1024,";
    private static final String SAVE_FLIGHT_OUTPUT_TO = System.getProperty("jmh.jfr.saveTo", ".");
    private final String jfrData = FileUtils.tempFile((String)".jfrData").getAbsolutePath();
    private static final boolean IS_SUPPORTED = ManagementFactory.getRuntimeMXBean().getInputArguments().contains("-XX:+UnlockCommercialFeatures");
    static int currentId;

    public Collection<String> addJVMInvokeOptions(BenchmarkParams benchmarkParams) {
        return Collections.emptyList();
    }

    public Collection<String> addJVMOptions(BenchmarkParams benchmarkParams) {
        this.startFlightRecordingOptions = this.startFlightRecordingOptions + "filename=" + this.jfrData;
        this.flightRecorderOptions = this.flightRecorderOptions + "settings=" + benchmarkParams.getJvm().replace("bin/java", "lib/jfr/profile.jfc");
        return Arrays.asList("-XX:+UnlockCommercialFeatures", "-XX:+FlightRecorder", "-XX:StartFlightRecording=" + this.startFlightRecordingOptions + "filename=" + this.jfrData, "-XX:FlightRecorderOptions=settings=" + benchmarkParams.getJvm().replace("bin/java", "lib/jfr/profile.jfc"));
    }

    public void beforeTrial(BenchmarkParams benchmarkParams) {
    }

    public Collection<? extends Result> afterTrial(BenchmarkResult benchmarkResult, long l, File file, File file2) {
        String string = SAVE_FLIGHT_OUTPUT_TO + "/" + benchmarkResult.getParams().id().replaceAll("/", "-") + "-" + currentId++ + ".jfr";
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        try {
            FileUtils.copy((String)this.jfrData, (String)string);
            printWriter.println("Flight Recording output saved to: \n  " + new File(string).getAbsolutePath());
        }
        catch (IOException iOException) {
            printWriter.println("Unable to save flight output to: \n  " + new File(string).getAbsolutePath());
        }
        printWriter.flush();
        printWriter.close();
        NoResult noResult = new NoResult(stringWriter.toString());
        return Collections.singleton(noResult);
    }

    public boolean allowPrintOut() {
        return true;
    }

    public boolean allowPrintErr() {
        return false;
    }

    public boolean checkSupport(List<String> list) {
        list.add("Commercial features of the JVM need to be enabled for this profiler.");
        return IS_SUPPORTED;
    }

    public String getDescription() {
        return "Java Flight Recording profiler runs for every benchmark.";
    }

    private class NoResult
    extends Result<NoResult> {
        private final String output;

        public NoResult(String string) {
            super(ResultRole.SECONDARY, "JFR", NoResult.of((double)Double.NaN), "N/A", AggregationPolicy.SUM);
            this.output = string;
        }

        protected Aggregator<NoResult> getThreadAggregator() {
            return new NoResultAggregator();
        }

        protected Aggregator<NoResult> getIterationAggregator() {
            return new NoResultAggregator();
        }

        public String extendedInfo() {
            return "JFR Messages:\n--------------------------------------------\n" + this.output;
        }

        private class NoResultAggregator
        implements Aggregator<NoResult> {
            private NoResultAggregator() {
            }

            public NoResult aggregate(Collection<NoResult> collection) {
                String string = "";
                for (NoResult noResult : collection) {
                    string = string + noResult.output;
                }
                return new NoResult(string);
            }
        }
    }
}

