/*
 * Decompiled with CFR 0.152.
 */
package pl.tajchert.buswear;

import android.content.Context;
import android.os.Looper;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import com.google.android.gms.wearable.MessageEvent;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import pl.tajchert.buswear.AsyncPoster;
import pl.tajchert.buswear.BackgroundPoster;
import pl.tajchert.buswear.EventBusBuilder;
import pl.tajchert.buswear.EventBusException;
import pl.tajchert.buswear.HandlerPoster;
import pl.tajchert.buswear.NoSubscriberEvent;
import pl.tajchert.buswear.PendingPost;
import pl.tajchert.buswear.SubscriberExceptionEvent;
import pl.tajchert.buswear.SubscriberMethod;
import pl.tajchert.buswear.SubscriberMethodFinder;
import pl.tajchert.buswear.Subscription;
import pl.tajchert.buswear.ThreadMode;
import pl.tajchert.buswear.wear.SendByteArrayToNode;
import pl.tajchert.buswear.wear.SendCommandToNode;
import pl.tajchert.buswear.wear.WearBusTools;

public class EventBus {
    public static String TAG = "Event";
    static volatile EventBus defaultInstance;
    private static final EventBusBuilder DEFAULT_BUILDER;
    private static final Map<Class<?>, List<Class<?>>> eventTypesCache;
    private final Map<Class<?>, CopyOnWriteArrayList<Subscription>> subscriptionsByEventType;
    private final Map<Object, List<Class<?>>> typesBySubscriber;
    private final Map<Class<?>, Object> stickyEvents;
    private static ArrayList<Class<?>> classList;
    private final ThreadLocal<PostingThreadState> currentPostingThreadState = new ThreadLocal<PostingThreadState>(){

        @Override
        protected PostingThreadState initialValue() {
            return new PostingThreadState();
        }
    };
    private final HandlerPoster mainThreadPoster;
    private final BackgroundPoster backgroundPoster;
    private final AsyncPoster asyncPoster;
    private final SubscriberMethodFinder subscriberMethodFinder;
    private final ExecutorService executorService;
    private final boolean throwSubscriberException;
    private final boolean logSubscriberExceptions;
    private final boolean logNoSubscriberMessages;
    private final boolean sendSubscriberExceptionEvent;
    private final boolean sendNoSubscriberEvent;
    private final boolean eventInheritance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static EventBus getDefault() {
        if (defaultInstance != null) return defaultInstance;
        Class<EventBus> clazz = EventBus.class;
        synchronized (EventBus.class) {
            if (defaultInstance != null) return defaultInstance;
            defaultInstance = new EventBus();
            // ** MonitorExit[var0] (shouldn't be in output)
            return defaultInstance;
        }
    }

    public static EventBusBuilder builder() {
        return new EventBusBuilder();
    }

    public static void clearCaches() {
        SubscriberMethodFinder.clearCaches();
        eventTypesCache.clear();
    }

    public EventBus() {
        this(DEFAULT_BUILDER);
    }

    EventBus(EventBusBuilder builder) {
        this.subscriptionsByEventType = new HashMap();
        this.typesBySubscriber = new HashMap();
        this.stickyEvents = new ConcurrentHashMap();
        this.mainThreadPoster = new HandlerPoster(this, Looper.getMainLooper(), 10);
        this.backgroundPoster = new BackgroundPoster(this);
        this.asyncPoster = new AsyncPoster(this);
        this.subscriberMethodFinder = new SubscriberMethodFinder(builder.skipMethodVerificationForClasses);
        this.logSubscriberExceptions = builder.logSubscriberExceptions;
        this.logNoSubscriberMessages = builder.logNoSubscriberMessages;
        this.sendSubscriberExceptionEvent = builder.sendSubscriberExceptionEvent;
        this.sendNoSubscriberEvent = builder.sendNoSubscriberEvent;
        this.throwSubscriberException = builder.throwSubscriberException;
        this.eventInheritance = builder.eventInheritance;
        this.executorService = builder.executorService;
    }

    public void register(Object subscriber) {
        this.register(subscriber, false, 0);
    }

    public void register(Object subscriber, int priority) {
        this.register(subscriber, false, priority);
    }

    public void registerSticky(Object subscriber) {
        this.register(subscriber, true, 0);
    }

    public void registerSticky(Object subscriber, int priority) {
        this.register(subscriber, true, priority);
    }

    private synchronized void register(Object subscriber, boolean sticky, int priority) {
        List<SubscriberMethod> subscriberMethods = this.subscriberMethodFinder.findSubscriberMethods(subscriber.getClass());
        for (SubscriberMethod subscriberMethod : subscriberMethods) {
            this.subscribe(subscriber, subscriberMethod, sticky, priority);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void subscribe(Object subscriber, SubscriberMethod subscriberMethod, boolean sticky, int priority) {
        List<Class<?>> subscribedEvents;
        Class<?> eventType = subscriberMethod.eventType;
        if (!classList.contains(eventType)) {
            classList.add(eventType);
        }
        CopyOnWriteArrayList<Subscription> subscriptions = this.subscriptionsByEventType.get(eventType);
        Subscription newSubscription = new Subscription(subscriber, subscriberMethod, priority);
        if (subscriptions == null) {
            subscriptions = new CopyOnWriteArrayList();
            this.subscriptionsByEventType.put(eventType, subscriptions);
        } else if (subscriptions.contains(newSubscription)) {
            throw new EventBusException("Subscriber " + subscriber.getClass() + " already registered to event " + eventType);
        }
        int size = subscriptions.size();
        for (int i = 0; i <= size; ++i) {
            if (i != size && newSubscription.priority <= subscriptions.get((int)i).priority) continue;
            subscriptions.add(i, newSubscription);
            break;
        }
        if ((subscribedEvents = this.typesBySubscriber.get(subscriber)) == null) {
            subscribedEvents = new ArrayList();
            this.typesBySubscriber.put(subscriber, subscribedEvents);
        }
        subscribedEvents.add(eventType);
        if (sticky) {
            Object stickyEvent;
            Map<Class<?>, Object> map = this.stickyEvents;
            synchronized (map) {
                stickyEvent = this.stickyEvents.get(eventType);
            }
            if (stickyEvent != null) {
                this.postToSubscription(newSubscription, stickyEvent, Looper.getMainLooper() == Looper.myLooper());
            }
        }
    }

    public synchronized boolean isRegistered(Object subscriber) {
        return this.typesBySubscriber.containsKey(subscriber);
    }

    private void unubscribeByEventType(Object subscriber, Class<?> eventType) {
        List subscriptions = this.subscriptionsByEventType.get(eventType);
        if (subscriptions != null) {
            int size = subscriptions.size();
            for (int i = 0; i < size; ++i) {
                Subscription subscription = (Subscription)subscriptions.get(i);
                if (subscription.subscriber != subscriber) continue;
                subscription.active = false;
                subscriptions.remove(i);
                --i;
                --size;
            }
        }
    }

    public synchronized void unregister(Object subscriber) {
        List<Class<?>> subscribedTypes = this.typesBySubscriber.get(subscriber);
        if (subscribedTypes != null) {
            for (Class<?> eventType : subscribedTypes) {
                this.unubscribeByEventType(subscriber, eventType);
            }
            this.typesBySubscriber.remove(subscriber);
        } else {
            Log.w((String)TAG, (String)("Subscriber to unregister was not registered before: " + subscriber.getClass()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void post(Object event, Context context) {
        block10: {
            PostingThreadState postingState = this.currentPostingThreadState.get();
            ArrayList<Object> eventQueue = postingState.eventQueue;
            eventQueue.add(event);
            if (!postingState.isPosting) {
                postingState.isMainThread = Looper.getMainLooper() == Looper.myLooper();
                postingState.isPosting = true;
                if (postingState.canceled) {
                    throw new EventBusException("Internal error. Abort state was not reset");
                }
                block5: while (true) {
                    while (!eventQueue.isEmpty()) {
                        Object obj = eventQueue.remove(0);
                        if (obj != null) {
                            this.postSingleEvent(obj, postingState);
                        }
                        byte[] objectInArray = WearBusTools.parseToSend(obj);
                        if (obj == null || objectInArray == null) continue;
                        try {
                            new SendByteArrayToNode(objectInArray, obj.getClass(), context, false).start();
                            continue block5;
                        }
                        catch (Exception e) {
                            if (!this.logNoSubscriberMessages) continue;
                            Log.e((String)TAG, (String)("Object cannot be send: " + e.getMessage()));
                        }
                    }
                    break block10;
                    {
                        continue block5;
                        break;
                    }
                    break;
                }
                finally {
                    postingState.isPosting = false;
                    postingState.isMainThread = false;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postLocal(Object event) {
        PostingThreadState postingState = this.currentPostingThreadState.get();
        ArrayList<Object> eventQueue = postingState.eventQueue;
        eventQueue.add(event);
        if (!postingState.isPosting) {
            postingState.isMainThread = Looper.getMainLooper() == Looper.myLooper();
            postingState.isPosting = true;
            if (postingState.canceled) {
                throw new EventBusException("Internal error. Abort state was not reset");
            }
            try {
                while (!eventQueue.isEmpty()) {
                    this.postSingleEvent(eventQueue.remove(0), postingState);
                }
            }
            finally {
                postingState.isPosting = false;
                postingState.isMainThread = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postRemote(Object event, Context context) {
        block9: {
            PostingThreadState postingState = this.currentPostingThreadState.get();
            ArrayList<Object> eventQueue = postingState.eventQueue;
            eventQueue.add(event);
            if (!postingState.isPosting) {
                postingState.isMainThread = Looper.getMainLooper() == Looper.myLooper();
                postingState.isPosting = true;
                if (postingState.canceled) {
                    throw new EventBusException("Internal error. Abort state was not reset");
                }
                block5: while (true) {
                    while (!eventQueue.isEmpty()) {
                        Object obj = eventQueue.remove(0);
                        byte[] objectInArray = WearBusTools.parseToSend(obj);
                        if (obj == null || objectInArray == null) continue;
                        try {
                            new SendByteArrayToNode(objectInArray, obj.getClass(), context, false).start();
                            continue block5;
                        }
                        catch (Exception e) {
                            if (!this.logNoSubscriberMessages) continue;
                            Log.e((String)TAG, (String)("Object cannot be send: " + e.getMessage()));
                        }
                    }
                    break block9;
                    {
                        continue block5;
                        break;
                    }
                    break;
                }
                finally {
                    postingState.isPosting = false;
                    postingState.isMainThread = false;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void postRemote(Object event, Context context, boolean isSticky) {
        block9: {
            PostingThreadState postingState = this.currentPostingThreadState.get();
            ArrayList<Object> eventQueue = postingState.eventQueue;
            eventQueue.add(event);
            if (!postingState.isPosting) {
                postingState.isMainThread = Looper.getMainLooper() == Looper.myLooper();
                postingState.isPosting = true;
                if (postingState.canceled) {
                    throw new EventBusException("Internal error. Abort state was not reset");
                }
                block5: while (true) {
                    while (!eventQueue.isEmpty()) {
                        Object obj = eventQueue.remove(0);
                        byte[] objectInArray = WearBusTools.parseToSend(obj);
                        if (obj == null || objectInArray == null) continue;
                        try {
                            new SendByteArrayToNode(objectInArray, obj.getClass(), context, isSticky).start();
                            continue block5;
                        }
                        catch (Exception e) {
                            if (!this.logNoSubscriberMessages) continue;
                            Log.e((String)TAG, (String)("Object cannot be send: " + e.getMessage()));
                        }
                    }
                    break block9;
                    {
                        continue block5;
                        break;
                    }
                    break;
                }
                finally {
                    postingState.isPosting = false;
                    postingState.isMainThread = false;
                }
            }
        }
    }

    public void cancelEventDelivery(Object event) {
        PostingThreadState postingState = this.currentPostingThreadState.get();
        if (!postingState.isPosting) {
            throw new EventBusException("This method may only be called from inside event handling methods on the posting thread");
        }
        if (event == null) {
            throw new EventBusException("Event may not be null");
        }
        if (postingState.event != event) {
            throw new EventBusException("Only the currently handled event may be aborted");
        }
        if (postingState.subscription.subscriberMethod.threadMode != ThreadMode.PostThread) {
            throw new EventBusException(" event handlers may only abort the incoming event");
        }
        postingState.canceled = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postSticky(Parcelable event, Context context) {
        Map<Class<?>, Object> map = this.stickyEvents;
        synchronized (map) {
            this.stickyEvents.put(event.getClass(), event);
        }
        this.postLocal(event);
        this.postRemote(event, context, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postStickyRemote(Parcelable event, Context context) {
        Map<Class<?>, Object> map = this.stickyEvents;
        synchronized (map) {
            this.stickyEvents.put(event.getClass(), event);
        }
        this.postRemote(event, context, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postStickyLocal(Object event) {
        Map<Class<?>, Object> map = this.stickyEvents;
        synchronized (map) {
            this.stickyEvents.put(event.getClass(), event);
        }
        this.postLocal(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T getStickyEvent(Class<T> eventType) {
        Map<Class<?>, Object> map = this.stickyEvents;
        synchronized (map) {
            return eventType.cast(this.stickyEvents.get(eventType));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T removeStickyEvent(Class<T> eventType, Context context) {
        this.removeStickyEventRemote(eventType, context);
        Map<Class<?>, Object> map = this.stickyEvents;
        synchronized (map) {
            return eventType.cast(this.stickyEvents.remove(eventType));
        }
    }

    public <T> void removeStickyEventRemote(Class<T> eventType, Context context) {
        new SendCommandToNode("pl.tajchert.buswear.command.class.", null, eventType, context).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T removeStickyEventLocal(Class<T> eventType) {
        Map<Class<?>, Object> map = this.stickyEvents;
        synchronized (map) {
            return eventType.cast(this.stickyEvents.remove(eventType));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeStickyEvent(Object event, Context context) {
        this.removeStickyEventRemote(event, context);
        Map<Class<?>, Object> map = this.stickyEvents;
        synchronized (map) {
            Class<?> eventType = event.getClass();
            Object existingEvent = this.stickyEvents.get(eventType);
            if (event.equals(existingEvent)) {
                this.stickyEvents.remove(eventType);
                return true;
            }
            return false;
        }
    }

    public void removeStickyEventRemote(Object event, Context context) {
        byte[] objectInArray = WearBusTools.parseToSend(event);
        if (event != null && objectInArray != null) {
            new SendCommandToNode("pl.tajchert.buswear.command.event.", objectInArray, event.getClass(), context).start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeStickyEventLocal(Object event) {
        Map<Class<?>, Object> map = this.stickyEvents;
        synchronized (map) {
            Class<?> eventType = event.getClass();
            Object existingEvent = this.stickyEvents.get(eventType);
            if (event.equals(existingEvent)) {
                this.stickyEvents.remove(eventType);
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllStickyEvents(Context context) {
        this.removeAllStickyEventsRemote(context);
        Map<Class<?>, Object> map = this.stickyEvents;
        synchronized (map) {
            this.stickyEvents.clear();
        }
    }

    public void removeAllStickyEventsRemote(Context context) {
        new SendCommandToNode("pl.tajchert.buswear.command.", "pl.tajchert.buswear.clearall".getBytes(), String.class, context).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllStickyEventsLocal() {
        Map<Class<?>, Object> map = this.stickyEvents;
        synchronized (map) {
            this.stickyEvents.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasSubscriberForEvent(Class<?> eventClass) {
        List<Class<?>> eventTypes = this.lookupAllEventTypes(eventClass);
        if (eventTypes != null) {
            int countTypes = eventTypes.size();
            for (int h = 0; h < countTypes; ++h) {
                CopyOnWriteArrayList<Subscription> subscriptions;
                Class<?> clazz = eventTypes.get(h);
                EventBus eventBus = this;
                synchronized (eventBus) {
                    subscriptions = this.subscriptionsByEventType.get(clazz);
                }
                if (subscriptions == null || subscriptions.isEmpty()) continue;
                return true;
            }
        }
        return false;
    }

    private void postSingleEvent(Object event, PostingThreadState postingState) throws Error {
        Class<?> eventClass = event.getClass();
        boolean subscriptionFound = false;
        if (this.eventInheritance) {
            List<Class<?>> eventTypes = this.lookupAllEventTypes(eventClass);
            int countTypes = eventTypes.size();
            for (int h = 0; h < countTypes; ++h) {
                Class<?> clazz = eventTypes.get(h);
                subscriptionFound |= this.postSingleEventForEventType(event, postingState, clazz);
            }
        } else {
            subscriptionFound = this.postSingleEventForEventType(event, postingState, eventClass);
        }
        if (!subscriptionFound && !(event instanceof NoSubscriberEvent)) {
            if (this.logNoSubscriberMessages) {
                Log.d((String)TAG, (String)("No local subscribers registered for event " + eventClass));
            }
            if (this.sendNoSubscriberEvent && eventClass != NoSubscriberEvent.class && eventClass != SubscriberExceptionEvent.class) {
                this.postLocal(new NoSubscriberEvent(this, event));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean postSingleEventForEventType(Object event, PostingThreadState postingState, Class<?> eventClass) {
        CopyOnWriteArrayList<Subscription> subscriptions;
        EventBus eventBus = this;
        synchronized (eventBus) {
            subscriptions = this.subscriptionsByEventType.get(eventClass);
        }
        if (subscriptions != null && !subscriptions.isEmpty()) {
            for (Subscription subscription : subscriptions) {
                postingState.event = event;
                postingState.subscription = subscription;
                boolean aborted = false;
                try {
                    this.postToSubscription(subscription, event, postingState.isMainThread);
                    aborted = postingState.canceled;
                }
                finally {
                    postingState.event = null;
                    postingState.subscription = null;
                    postingState.canceled = false;
                }
                if (!aborted) continue;
                break;
            }
            return true;
        }
        return false;
    }

    private void postToSubscription(Subscription subscription, Object event, boolean isMainThread) {
        switch (subscription.subscriberMethod.threadMode) {
            case PostThread: {
                this.invokeSubscriber(subscription, event);
                break;
            }
            case MainThread: {
                if (isMainThread) {
                    this.invokeSubscriber(subscription, event);
                    break;
                }
                this.mainThreadPoster.enqueue(subscription, event);
                break;
            }
            case BackgroundThread: {
                if (isMainThread) {
                    this.backgroundPoster.enqueue(subscription, event);
                    break;
                }
                this.invokeSubscriber(subscription, event);
                break;
            }
            case Async: {
                this.asyncPoster.enqueue(subscription, event);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown thread mode: " + (Object)((Object)subscription.subscriberMethod.threadMode));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Class<?>> lookupAllEventTypes(Class<?> eventClass) {
        Map<Class<?>, List<Class<?>>> map = eventTypesCache;
        synchronized (map) {
            List<Class<?>> eventTypes = eventTypesCache.get(eventClass);
            if (eventTypes == null) {
                eventTypes = new ArrayList();
                for (Class<?> clazz = eventClass; clazz != null; clazz = clazz.getSuperclass()) {
                    eventTypes.add(clazz);
                    EventBus.addInterfaces(eventTypes, clazz.getInterfaces());
                }
                eventTypesCache.put(eventClass, eventTypes);
            }
            return eventTypes;
        }
    }

    static void addInterfaces(List<Class<?>> eventTypes, Class<?>[] interfaces) {
        for (Class<?> interfaceClass : interfaces) {
            if (eventTypes.contains(interfaceClass)) continue;
            eventTypes.add(interfaceClass);
            EventBus.addInterfaces(eventTypes, interfaceClass.getInterfaces());
        }
    }

    void invokeSubscriber(PendingPost pendingPost) {
        Object event = pendingPost.event;
        Subscription subscription = pendingPost.subscription;
        PendingPost.releasePendingPost(pendingPost);
        if (subscription.active) {
            this.invokeSubscriber(subscription, event);
        }
    }

    void invokeSubscriber(Subscription subscription, Object event) {
        try {
            subscription.subscriberMethod.method.invoke(subscription.subscriber, event);
        }
        catch (InvocationTargetException e) {
            this.handleSubscriberException(subscription, event, e.getCause());
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Unexpected exception", e);
        }
    }

    private void handleSubscriberException(Subscription subscription, Object event, Throwable cause) {
        if (event instanceof SubscriberExceptionEvent) {
            if (this.logSubscriberExceptions) {
                Log.e((String)TAG, (String)("SubscriberExceptionEvent subscriber " + subscription.subscriber.getClass() + " threw an exception"), (Throwable)cause);
                SubscriberExceptionEvent exEvent = (SubscriberExceptionEvent)event;
                Log.e((String)TAG, (String)("Initial event " + exEvent.causingEvent + " caused exception in " + exEvent.causingSubscriber), (Throwable)exEvent.throwable);
            }
        } else {
            if (this.throwSubscriberException) {
                throw new EventBusException("Invoking subscriber failed", cause);
            }
            if (this.logSubscriberExceptions) {
                Log.e((String)TAG, (String)("Could not dispatch event: " + event.getClass() + " to subscribing class " + subscription.subscriber.getClass()), (Throwable)cause);
            }
            if (this.sendSubscriberExceptionEvent) {
                SubscriberExceptionEvent exEvent = new SubscriberExceptionEvent(this, cause, event, subscription.subscriber);
                this.postLocal(exEvent);
            }
        }
    }

    ExecutorService getExecutorService() {
        return this.executorService;
    }

    public static void syncEvent(MessageEvent messageEvent) {
        byte[] objectArray = messageEvent.getData();
        if (messageEvent.getPath().contains("pl.tajchert.buswear.event.")) {
            String className = messageEvent.getPath().substring(messageEvent.getPath().lastIndexOf(".") + 1);
            Object obj = WearBusTools.getSendSimpleObject(objectArray, className);
            if (obj == null) {
                obj = EventBus.findParcel(objectArray, className);
            }
            if (obj != null) {
                EventBus.getDefault().postLocal(obj);
            }
        } else if (messageEvent.getPath().contains("pl.tajchert.buswear.stickyevent.")) {
            String className = messageEvent.getPath().substring(messageEvent.getPath().lastIndexOf(".") + 1);
            Object obj = WearBusTools.getSendSimpleObject(objectArray, className);
            if (obj == null) {
                obj = EventBus.findParcel(objectArray, className);
            }
            if (obj != null) {
                EventBus.getDefault().postStickyLocal(obj);
            }
        } else if (messageEvent.getPath().contains("pl.tajchert.buswear.command.")) {
            EventBus.stickyEventCommand(messageEvent, objectArray);
        }
    }

    private static void stickyEventCommand(MessageEvent messageEvent, byte[] objectArray) {
        String className = messageEvent.getPath().substring(messageEvent.getPath().lastIndexOf(".") + 1);
        if (className.equals("String")) {
            String action = new String(objectArray);
            Log.d((String)TAG, (String)("syncEvent action: " + action));
            if (action.equals("pl.tajchert.buswear.clearall")) {
                EventBus.getDefault().removeAllStickyEventsLocal();
            } else {
                for (Class<?> classTmp : classList) {
                    if (!className.equals(classTmp.getSimpleName())) continue;
                    EventBus.getDefault().removeStickyEventLocal(classTmp);
                }
            }
        } else {
            int dotPlace = messageEvent.getPath().lastIndexOf(".");
            String typeOfRemove = messageEvent.getPath().substring(dotPlace - 5, dotPlace);
            if (typeOfRemove.equals("class")) {
                for (Class<?> classTmp : classList) {
                    if (!className.equals(classTmp.getSimpleName())) continue;
                    EventBus.getDefault().removeStickyEventLocal(classTmp);
                }
            } else {
                Object obj = WearBusTools.getSendSimpleObject(objectArray, className);
                if (obj == null) {
                    obj = EventBus.findParcel(objectArray, className);
                }
                if (obj != null) {
                    EventBus.getDefault().removeStickyEventLocal(obj);
                }
            }
        }
    }

    private static Object findParcel(byte[] objectArray, String className) {
        for (Class<?> classTmp : classList) {
            if (!className.equals(classTmp.getSimpleName())) continue;
            try {
                return classTmp.getConstructor(Parcel.class).newInstance(WearBusTools.byteToParcel(objectArray));
            }
            catch (Exception e) {
                try {
                    Log.d((String)"BusWearTag", (String)("syncEvent error: " + e.getMessage()));
                }
                catch (Exception e2) {
                    Log.d((String)TAG, (String)("syncEvent error: " + e2.getMessage()));
                }
            }
        }
        return null;
    }

    static {
        DEFAULT_BUILDER = new EventBusBuilder();
        eventTypesCache = new HashMap();
        classList = new ArrayList();
    }

    static interface PostCallback {
        public void onPostCompleted(List<SubscriberExceptionEvent> var1);
    }

    static final class PostingThreadState {
        final ArrayList<Object> eventQueue = new ArrayList();
        boolean isPosting;
        boolean isMainThread;
        Subscription subscription;
        Object event;
        boolean canceled;

        PostingThreadState() {
        }
    }
}

