/*
 * Decompiled with CFR 0.152.
 */
package pl.tajchert.buswear;

import android.util.Log;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import pl.tajchert.buswear.EventBus;
import pl.tajchert.buswear.EventBusException;
import pl.tajchert.buswear.SubscriberMethod;
import pl.tajchert.buswear.ThreadMode;

class SubscriberMethodFinder {
    private static final String ON_EVENT_METHOD_NAME = "onEvent";
    private static final int BRIDGE = 64;
    private static final int SYNTHETIC = 4096;
    private static final int MODIFIERS_IGNORE = 5192;
    private static final Map<String, List<SubscriberMethod>> methodCache = new HashMap<String, List<SubscriberMethod>>();
    private final Map<Class<?>, Class<?>> skipMethodVerificationForClasses = new ConcurrentHashMap();

    SubscriberMethodFinder(List<Class<?>> skipMethodVerificationForClassesList) {
        if (skipMethodVerificationForClassesList != null) {
            for (Class<?> clazz : skipMethodVerificationForClassesList) {
                this.skipMethodVerificationForClasses.put(clazz, clazz);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<SubscriberMethod> findSubscriberMethods(Class<?> subscriberClass) {
        String name;
        List<SubscriberMethod> subscriberMethods;
        String key = subscriberClass.getName();
        Map<String, List<SubscriberMethod>> map = methodCache;
        synchronized (map) {
            subscriberMethods = methodCache.get(key);
        }
        if (subscriberMethods != null) {
            return subscriberMethods;
        }
        subscriberMethods = new ArrayList<SubscriberMethod>();
        HashSet<String> eventTypesFound = new HashSet<String>();
        StringBuilder methodKeyBuilder = new StringBuilder();
        for (Class<?> clazz = subscriberClass; !(clazz == null || (name = clazz.getName()).startsWith("java.") || name.startsWith("javax.") || name.startsWith("android.")); clazz = clazz.getSuperclass()) {
            Method[] methods;
            for (Method method : methods = clazz.getDeclaredMethods()) {
                String methodName = method.getName();
                if (!methodName.startsWith(ON_EVENT_METHOD_NAME)) continue;
                int modifiers = method.getModifiers();
                if ((modifiers & 1) != 0 && (modifiers & 0x1448) == 0) {
                    ThreadMode threadMode;
                    Class<?>[] parameterTypes = method.getParameterTypes();
                    if (parameterTypes.length != 1) continue;
                    String modifierString = methodName.substring(ON_EVENT_METHOD_NAME.length());
                    if (modifierString.length() == 0) {
                        threadMode = ThreadMode.PostThread;
                    } else if (modifierString.equals("MainThread")) {
                        threadMode = ThreadMode.MainThread;
                    } else if (modifierString.equals("BackgroundThread")) {
                        threadMode = ThreadMode.BackgroundThread;
                    } else if (modifierString.equals("Async")) {
                        threadMode = ThreadMode.Async;
                    } else {
                        if (this.skipMethodVerificationForClasses.containsKey(clazz)) continue;
                        throw new EventBusException("Illegal onEvent method, check for typos: " + method);
                    }
                    Class<?> eventType = parameterTypes[0];
                    methodKeyBuilder.setLength(0);
                    methodKeyBuilder.append(methodName);
                    methodKeyBuilder.append('>').append(eventType.getName());
                    String methodKey = methodKeyBuilder.toString();
                    if (!eventTypesFound.add(methodKey)) continue;
                    subscriberMethods.add(new SubscriberMethod(method, threadMode, eventType));
                    continue;
                }
                if (this.skipMethodVerificationForClasses.containsKey(clazz)) continue;
                Log.d((String)EventBus.TAG, (String)("Skipping method (not public, static or abstract): " + clazz + "." + methodName));
            }
        }
        if (subscriberMethods.isEmpty()) {
            throw new EventBusException("Subscriber " + subscriberClass + " has no public methods called " + ON_EVENT_METHOD_NAME);
        }
        Map<String, List<SubscriberMethod>> map2 = methodCache;
        synchronized (map2) {
            methodCache.put(key, subscriberMethods);
        }
        return subscriberMethods;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void clearCaches() {
        Map<String, List<SubscriberMethod>> map = methodCache;
        synchronized (map) {
            methodCache.clear();
        }
    }
}

