/*
 * Decompiled with CFR 0.152.
 */
package pl.tajchert.buswear.wear;

import android.content.Context;
import android.util.Log;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.wearable.MessageApi;
import com.google.android.gms.wearable.Node;
import com.google.android.gms.wearable.NodeApi;
import com.google.android.gms.wearable.Wearable;
import java.util.concurrent.TimeUnit;
import pl.tajchert.buswear.wear.SendWearManager;

public class SendByteArrayToNode
extends Thread {
    private byte[] objectArray;
    private Context context;
    private boolean sticky;
    private Class clazzToSend;

    public SendByteArrayToNode(byte[] objArray, Class classToSend, Context ctx, boolean isSticky) {
        this.objectArray = objArray;
        this.context = ctx;
        this.sticky = isSticky;
        this.clazzToSend = classToSend;
    }

    @Override
    public void run() {
        if (this.objectArray.length / 1024 > 100) {
            throw new RuntimeException("Object is too big to push it via Google Play Services");
        }
        GoogleApiClient googleApiClient = SendWearManager.getInstance(this.context);
        googleApiClient.blockingConnect(100L, TimeUnit.MILLISECONDS);
        NodeApi.GetConnectedNodesResult nodes = (NodeApi.GetConnectedNodesResult)Wearable.NodeApi.getConnectedNodes(googleApiClient).await();
        for (Node node : nodes.getNodes()) {
            MessageApi.SendMessageResult result = this.sticky ? (MessageApi.SendMessageResult)Wearable.MessageApi.sendMessage(googleApiClient, node.getId(), "pl.tajchert.buswear.stickyevent." + this.clazzToSend.getSimpleName(), this.objectArray).await() : (MessageApi.SendMessageResult)Wearable.MessageApi.sendMessage(googleApiClient, node.getId(), "pl.tajchert.buswear.event." + this.clazzToSend.getSimpleName(), this.objectArray).await();
            if (result.getStatus().isSuccess()) continue;
            Log.v((String)"BusWearTag", (String)"ERROR: failed to send Message via Google Play Services");
        }
    }
}

