/*
 * Decompiled with CFR 0.152.
 */
package pl.tkowalcz.tjahzi;

import java.nio.ByteBuffer;
import java.util.Map;
import org.agrona.concurrent.ringbuffer.ManyToOneRingBuffer;
import pl.tkowalcz.tjahzi.LogBufferSerializer;
import pl.tkowalcz.tjahzi.stats.MonitoringModule;

public class TjahziLogger {
    public static final int LOG_MESSAGE_TYPE_ID = 5;
    private final ManyToOneRingBuffer logBuffer;
    private final MonitoringModule monitoringModule;
    private final LogBufferSerializer serializer;

    public TjahziLogger(ManyToOneRingBuffer logBuffer, MonitoringModule monitoringModule) {
        this.logBuffer = logBuffer;
        this.monitoringModule = monitoringModule;
        this.serializer = new LogBufferSerializer(logBuffer.buffer());
    }

    public TjahziLogger log(long timestamp, Map<String, String> labels, String logLevelLabel, String logLevel, ByteBuffer line) {
        int requiredSize = this.serializer.calculateRequiredSizeAscii(labels, logLevelLabel, logLevel, line);
        int claim = this.logBuffer.tryClaim(5, requiredSize);
        if (claim > 0) {
            this.putMessageOnRing(timestamp, labels, logLevelLabel, logLevel, line, claim);
        } else {
            this.monitoringModule.incrementDroppedPuts();
        }
        return this;
    }

    private void putMessageOnRing(long timestamp, Map<String, String> labels, String logLevelLabel, String logLevel, ByteBuffer line, int claim) {
        try {
            this.serializer.writeTo(claim, timestamp, labels, logLevelLabel, logLevel, line);
            this.logBuffer.commit(claim);
        }
        catch (Throwable t) {
            this.logBuffer.abort(claim);
            this.monitoringModule.incrementDroppedPuts(t);
        }
    }
}

