/*
 * Decompiled with CFR 0.152.
 */
package pl.tkowalcz.tjahzi.http;

import java.util.function.Consumer;
import pl.tkowalcz.tjahzi.http.ExponentialBackoffStrategy;
import pl.tkowalcz.tjahzi.http.Retry;
import pl.tkowalcz.tjahzi.stats.MonitoringModule;

class BlockingRetry
implements Retry {
    private final ExponentialBackoffStrategy strategy;
    private final Consumer<BlockingRetry> operation;
    private final MonitoringModule monitoringModule;
    private int retries;

    BlockingRetry(Consumer<BlockingRetry> operation, ExponentialBackoffStrategy strategy, int retries, MonitoringModule monitoringModule) {
        this.operation = operation;
        this.strategy = strategy;
        this.retries = retries;
        this.monitoringModule = monitoringModule;
    }

    BlockingRetry(Consumer<BlockingRetry> operation, int retries, MonitoringModule monitoringModule) {
        this(operation, ExponentialBackoffStrategy.withDefault(), retries, monitoringModule);
    }

    @Override
    public void retry() {
        if (this.retries > 0) {
            --this.retries;
            this.monitoringModule.incrementRetriedHttpRequests();
            try {
                Thread.sleep(this.strategy.getAsLong(), 0);
            }
            catch (InterruptedException ignore) {
                return;
            }
            this.operation.accept(this);
        } else {
            this.monitoringModule.incrementFailedHttpRequests();
        }
    }
}

