/*
 * Decompiled with CFR 0.152.
 */
package pl.tkowalcz.tjahzi.http;

import pl.tkowalcz.tjahzi.http.ClientConfiguration;

public class ClientConfigurationBuilder {
    public static final String DEFAULT_LOG_ENDPOINT = "/loki/api/v1/push";
    public static final int DEFAULT_CONNECT_TIMEOUT_MILLIS = 5000;
    public static final int DEFAULT_REQUEST_TIMEOUT_MILLIS = 60000;
    public static final int DEFAULT_MAX_REQUESTS_IN_FLIGHT = 100;
    public static final int DEFAULT_MAX_RETRIES = 0;
    private String logEndpoint = "/loki/api/v1/push";
    private String host;
    private int port;
    private int connectionTimeoutMillis = 5000;
    private int requestTimeoutMillis = 60000;
    private int maxRequestsInFlight = 100;
    private int maxRetries = 0;

    public ClientConfigurationBuilder withLogEndpoint(String logEndpoint) {
        this.logEndpoint = logEndpoint;
        return this;
    }

    public ClientConfigurationBuilder withHost(String host) {
        this.host = host;
        return this;
    }

    public ClientConfigurationBuilder withPort(int port) {
        this.port = port;
        return this;
    }

    public ClientConfigurationBuilder withConnectionTimeoutMillis(int connectionTimeoutMillis) {
        this.connectionTimeoutMillis = connectionTimeoutMillis;
        return this;
    }

    public ClientConfigurationBuilder withRequestTimeoutMillis(int requestTimeoutMillis) {
        this.requestTimeoutMillis = requestTimeoutMillis;
        return this;
    }

    public ClientConfigurationBuilder withMaxRequestsInFlight(int maxRequestsInFlight) {
        this.maxRequestsInFlight = maxRequestsInFlight;
        return this;
    }

    public ClientConfigurationBuilder withMaxRetries(int maxRetries) {
        this.maxRetries = maxRetries;
        return this;
    }

    public ClientConfiguration build() {
        if (this.maxRequestsInFlight <= 0) {
            throw new IllegalArgumentException("Property maxRequestsInFlight must be greater than 0");
        }
        return new ClientConfiguration(this.logEndpoint, this.host, this.port, this.connectionTimeoutMillis, this.requestTimeoutMillis, this.maxRequestsInFlight, this.maxRetries);
    }
}

