/*
 * Decompiled with CFR 0.152.
 */
package pl.tkowalcz.tjahzi.http;

import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import pl.tkowalcz.tjahzi.http.ExponentialBackoffStrategy;
import pl.tkowalcz.tjahzi.http.Retry;
import pl.tkowalcz.tjahzi.stats.MonitoringModule;

class EventLoopGroupRetry
implements Retry,
Runnable {
    private final ScheduledExecutorService group;
    private final Consumer<EventLoopGroupRetry> operation;
    private final ExponentialBackoffStrategy strategy;
    private final MonitoringModule monitoringModule;

    public EventLoopGroupRetry(ScheduledExecutorService group, Consumer<EventLoopGroupRetry> operation, ExponentialBackoffStrategy strategy, MonitoringModule monitoringModule) {
        this.group = group;
        this.operation = operation;
        this.strategy = strategy;
        this.monitoringModule = monitoringModule;
    }

    public EventLoopGroupRetry(ScheduledExecutorService group, Consumer<EventLoopGroupRetry> operation, MonitoringModule monitoringModule) {
        this(group, operation, ExponentialBackoffStrategy.withDefault(), monitoringModule);
    }

    @Override
    public void run() {
        this.monitoringModule.incrementHttpConnectAttempts();
        this.operation.accept(this);
    }

    @Override
    public void retry() {
        this.group.schedule(this, this.strategy.getAsLong(), TimeUnit.MILLISECONDS);
    }
}

