/*
 * Decompiled with CFR 0.152.
 */
package pl.tkowalcz.tjahzi.http;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpContentDecompressor;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.timeout.IdleStateHandler;
import pl.tkowalcz.tjahzi.http.PipelinedHttpRequestTimer;
import pl.tkowalcz.tjahzi.http.RequestAndResponseHandler;
import pl.tkowalcz.tjahzi.stats.MonitoringModule;

class HttpClientInitializer
extends ChannelInitializer<Channel> {
    private static final int BYTES_IN_MEGABYTE = 0x100000;
    private static final int MAX_CONTENT_LENGTH = 0xA00000;
    private final MonitoringModule monitoringModule;
    private final RequestAndResponseHandler responseHandler;
    private final int requestTimeoutMillis;
    private final int maxRequestsInFlight;

    HttpClientInitializer(MonitoringModule monitoringModule, int requestTimeoutMillis, int maxRequestsInFlight) {
        this.monitoringModule = monitoringModule;
        this.responseHandler = new RequestAndResponseHandler(monitoringModule);
        this.requestTimeoutMillis = requestTimeoutMillis;
        this.maxRequestsInFlight = maxRequestsInFlight;
    }

    protected void initChannel(Channel ch) {
        ChannelPipeline p = ch.pipeline();
        p.addLast(new ChannelHandler[]{new IdleStateHandler(this.requestTimeoutMillis, 0, 60)});
        p.addLast(new ChannelHandler[]{new HttpClientCodec()});
        p.addLast(new ChannelHandler[]{new HttpObjectAggregator(0xA00000)});
        p.addLast(new ChannelHandler[]{new HttpContentDecompressor()});
        p.addLast(new ChannelHandler[]{new PipelinedHttpRequestTimer(this.monitoringModule, this.maxRequestsInFlight)});
        p.addLast(new ChannelHandler[]{this.responseHandler});
    }
}

