/*
 * Decompiled with CFR 0.152.
 */
package pl.tkowalcz.tjahzi.http;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.ReadOnlyHttpHeaders;
import io.netty.util.ReferenceCountUtil;
import java.io.Closeable;
import java.io.IOException;
import pl.tkowalcz.tjahzi.OutputBuffer;
import pl.tkowalcz.tjahzi.http.ClientConfiguration;
import pl.tkowalcz.tjahzi.http.HttpConnection;
import pl.tkowalcz.tjahzi.http.Snappy;
import pl.tkowalcz.tjahzi.stats.MonitoringModule;

public class NettyHttpClient
implements Closeable {
    public static final String PROTOBUF_MIME_TYPE = "application/x-protobuf";
    private final ClientConfiguration clientConfiguration;
    private final HttpHeaders headers;
    private final Snappy snappy = new Snappy();
    private final HttpConnection lokiConnection;

    public NettyHttpClient(ClientConfiguration clientConfiguration, MonitoringModule monitoringModule, String[] additionalHeaders) {
        this.clientConfiguration = clientConfiguration;
        this.headers = new ReadOnlyHttpHeaders(true, (CharSequence[])additionalHeaders);
        this.lokiConnection = new HttpConnection(clientConfiguration, monitoringModule);
    }

    public void log(ByteBuf dataBuffer) {
        DefaultFullHttpRequest request = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.POST, this.clientConfiguration.getLogEndpoint(), dataBuffer);
        request.headers().add(this.headers).set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)PROTOBUF_MIME_TYPE).set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)dataBuffer.readableBytes()).set((CharSequence)HttpHeaderNames.HOST, (Object)this.clientConfiguration.getHost());
        this.lokiConnection.execute((FullHttpRequest)request);
    }

    @Override
    public void close() {
        this.lokiConnection.close();
    }

    public void log(OutputBuffer outputBuffer) throws IOException {
        ByteBuf dataBuffer = outputBuffer.close();
        ByteBuf compressedBuffer = PooledByteBufAllocator.DEFAULT.buffer();
        try {
            this.snappy.encode(dataBuffer, compressedBuffer, dataBuffer.readableBytes());
        }
        catch (Exception e) {
            ReferenceCountUtil.safeRelease((Object)compressedBuffer);
            throw e;
        }
        this.log(compressedBuffer);
    }
}

