/*
 * Decompiled with CFR 0.152.
 */
package pl.tkowalcz.tjahzi.stats;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.time.Clock;
import java.util.concurrent.TimeUnit;
import pl.tkowalcz.tjahzi.stats.MonitoringModule;

public class DropwizardMonitoringModule
implements MonitoringModule {
    private final Counter droppedPuts;
    private final Counter httpConnectAttempts;
    private final Counter sentHttpRequests;
    private final Meter sentBytes;
    private final Counter failedHttpRequests;
    private final Counter retriedHttpRequests;
    private final Counter httpResponses;
    private final Timer responseTimes;
    private final Counter channelInactive;
    private final Counter agentErrors;
    private final Counter responseErrors;

    public DropwizardMonitoringModule(MetricRegistry metricRegistry, String prefix) {
        this.droppedPuts = metricRegistry.counter(prefix + ".droppedPuts");
        this.httpConnectAttempts = metricRegistry.counter(prefix + ".httpConnectAttempts");
        this.sentHttpRequests = metricRegistry.counter(prefix + ".sentHttpRequests");
        this.sentBytes = metricRegistry.meter(prefix + ".sentBytes");
        this.failedHttpRequests = metricRegistry.counter(prefix + ".failedHttpRequests");
        this.retriedHttpRequests = metricRegistry.counter(prefix + ".retriedHttpRequests");
        this.httpResponses = metricRegistry.counter(prefix + ".httpResponses");
        this.responseTimes = metricRegistry.timer(prefix + ".responseTimes");
        this.channelInactive = metricRegistry.counter(prefix + ".channelInactive");
        this.agentErrors = metricRegistry.counter(prefix + ".agentErrors");
        this.responseErrors = metricRegistry.counter(prefix + ".responseErrors");
    }

    @Override
    public Clock getClock() {
        return Clock.systemUTC();
    }

    @Override
    public void incrementDroppedPuts() {
        this.droppedPuts.inc();
    }

    @Override
    public void incrementDroppedPuts(Throwable throwable) {
        this.incrementDroppedPuts();
    }

    @Override
    public void incrementSentHttpRequests(int sizeBytes) {
        this.sentHttpRequests.inc();
        this.sentBytes.mark((long)sizeBytes);
    }

    @Override
    public void incrementFailedHttpRequests() {
        this.failedHttpRequests.inc();
    }

    @Override
    public void incrementRetriedHttpRequests() {
        this.retriedHttpRequests.inc();
    }

    @Override
    public void addAgentError(Throwable throwable) {
        this.agentErrors.inc();
    }

    @Override
    public void incrementHttpConnectAttempts() {
        this.httpConnectAttempts.inc();
    }

    @Override
    public void incrementChannelInactive() {
        this.channelInactive.inc();
    }

    @Override
    public void incrementHttpResponses() {
        this.httpResponses.inc();
    }

    @Override
    public void addPipelineError(Throwable cause) {
        this.responseErrors.inc();
    }

    @Override
    public void incrementHttpErrors(HttpResponseStatus status, ByteBuf content) {
        this.responseErrors.inc();
    }

    @Override
    public void recordResponseTime(long time) {
        this.responseTimes.update(time, TimeUnit.MILLISECONDS);
    }

    public String toString() {
        return "StandardMonitoringModule{droppedPuts=" + this.droppedPuts.getCount() + ", httpConnectAttempts=" + this.httpConnectAttempts + ", sentHttpRequests=" + this.sentHttpRequests + ", sentKilobytes=" + this.sentBytes.getCount() / 1024L + ", failedHttpRequests=" + this.failedHttpRequests + ", retriedHttpRequests=" + this.retriedHttpRequests + ", httpResponses=" + this.httpResponses + ", channelInactive=" + this.channelInactive + ", agentErrors=" + this.agentErrors + "}";
    }
}

