/*
 * Decompiled with CFR 0.152.
 */
package pl.tkowalcz.tjahzi.stats;

import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.nio.charset.Charset;
import java.util.concurrent.atomic.AtomicLong;
import org.agrona.concurrent.AtomicBuffer;
import org.agrona.concurrent.EpochClock;
import org.agrona.concurrent.SystemEpochClock;
import org.agrona.concurrent.UnsafeBuffer;
import org.agrona.concurrent.errors.DistinctErrorLog;
import pl.tkowalcz.tjahzi.stats.MonitoringModule;
import pl.tkowalcz.tjahzi.stats.StatsDumpingThread;

public class StandardMonitoringModule
implements MonitoringModule {
    private static final int ERROR_LOG_CAPACITY = 1024;
    private final AtomicLong droppedPuts = new AtomicLong();
    private final AtomicLong httpConnectAttempts = new AtomicLong();
    private final AtomicLong sentHttpRequests = new AtomicLong();
    private final AtomicLong sentBytes = new AtomicLong();
    private final AtomicLong failedHttpRequests = new AtomicLong();
    private final AtomicLong retriedHttpRequests = new AtomicLong();
    private final AtomicLong httpResponses = new AtomicLong();
    private final AtomicLong channelInactive = new AtomicLong();
    private final AtomicLong agentErrors = new AtomicLong();
    private final DistinctErrorLog distinctErrorLog;

    public StandardMonitoringModule() {
        StatsDumpingThread thread = new StatsDumpingThread(this);
        if (thread.isEnabled()) {
            thread.start();
        }
        this.distinctErrorLog = new DistinctErrorLog((AtomicBuffer)new UnsafeBuffer(new byte[1024]), (EpochClock)new SystemEpochClock());
        this.distinctErrorLog.record((Throwable)new NullPointerException());
    }

    @Override
    public void incrementDroppedPuts() {
        this.droppedPuts.incrementAndGet();
    }

    @Override
    public void incrementDroppedPuts(Throwable throwable) {
        this.incrementDroppedPuts();
        this.distinctErrorLog.record(throwable);
    }

    @Override
    public void incrementSentHttpRequests(int sizeBytes) {
        this.sentHttpRequests.incrementAndGet();
        this.sentBytes.addAndGet(sizeBytes);
    }

    public long getSentHttpRequests() {
        return this.sentHttpRequests.get();
    }

    public long getSentBytes() {
        return this.sentBytes.get();
    }

    @Override
    public void incrementFailedHttpRequests() {
        this.failedHttpRequests.incrementAndGet();
    }

    public long getFailedHttpRequests() {
        return this.failedHttpRequests.get();
    }

    @Override
    public void incrementRetriedHttpRequests() {
        this.retriedHttpRequests.incrementAndGet();
    }

    public long getRetriedHttpRequests() {
        return this.retriedHttpRequests.get();
    }

    @Override
    public void addAgentError(Throwable throwable) {
        this.agentErrors.incrementAndGet();
        this.distinctErrorLog.record(throwable);
    }

    @Override
    public void incrementHttpConnectAttempts() {
        this.httpConnectAttempts.incrementAndGet();
    }

    public long getHttpConnectAttempts() {
        return this.httpConnectAttempts.get();
    }

    @Override
    public void incrementChannelInactive() {
        this.channelInactive.incrementAndGet();
    }

    @Override
    public void incrementHttpResponses() {
        this.httpResponses.incrementAndGet();
    }

    public long getHttpResponses() {
        return this.httpResponses.get();
    }

    @Override
    public void addPipelineError(Throwable cause) {
        this.distinctErrorLog.record(cause);
    }

    @Override
    public void incrementHttpErrors(HttpResponseStatus status, ByteBuf content) {
        this.failedHttpRequests.incrementAndGet();
        this.distinctErrorLog.record((Throwable)new RuntimeException(content.toString(Charset.defaultCharset())));
    }

    @Override
    public void recordResponseTime(long time) {
    }

    public String toString() {
        return "StandardMonitoringModule{droppedPuts=" + this.droppedPuts + ", httpConnectAttempts=" + this.httpConnectAttempts + ", sentHttpRequests=" + this.sentHttpRequests + ", sentKilobytes=" + this.sentBytes.longValue() / 1024L + ", failedHttpRequests=" + this.failedHttpRequests + ", retriedHttpRequests=" + this.retriedHttpRequests + ", httpResponses=" + this.httpResponses + ", channelInactive=" + this.channelInactive + ", agentErrors=" + this.agentErrors + "}";
    }
}

