/*
 * Decompiled with CFR 0.152.
 */
package pl.tkowalcz.tjahzi;

import java.io.IOException;
import java.time.Clock;
import java.util.Map;
import pl.tkowalcz.tjahzi.LogBufferTranscoder;
import pl.tkowalcz.tjahzi.OutputBuffer;
import pl.tkowalcz.tjahzi.http.NettyHttpClient;
import pl.tkowalcz.tjahzi.io.netty.buffer.PooledByteBufAllocator;
import pl.tkowalcz.tjahzi.org.agrona.MutableDirectBuffer;
import pl.tkowalcz.tjahzi.org.agrona.concurrent.Agent;
import pl.tkowalcz.tjahzi.org.agrona.concurrent.MessageHandler;
import pl.tkowalcz.tjahzi.org.agrona.concurrent.ringbuffer.ManyToOneRingBuffer;

public class LogBufferAgent
implements Agent,
MessageHandler {
    public static final int MAX_MESSAGES_TO_RETRIEVE = 100;
    private final Clock clock;
    private final ManyToOneRingBuffer logBuffer;
    private final NettyHttpClient httpClient;
    private final long batchSize;
    private final long batchWaitMillis;
    private final OutputBuffer outputBuffer;
    private final LogBufferTranscoder logBufferTranscoder;
    private long timeoutDeadline;

    public LogBufferAgent(Clock clock, ManyToOneRingBuffer logBuffer, NettyHttpClient httpClient, long batchSizeBytes, long batchWaitMillis, Map<String, String> staticLabels) {
        this.clock = clock;
        this.logBuffer = logBuffer;
        this.batchSize = batchSizeBytes;
        this.batchWaitMillis = batchWaitMillis;
        this.httpClient = httpClient;
        this.outputBuffer = new OutputBuffer(PooledByteBufAllocator.DEFAULT.buffer());
        this.logBufferTranscoder = new LogBufferTranscoder(staticLabels, logBuffer.buffer());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int doWork() throws IOException {
        int workDone = this.logBuffer.read(this, 100);
        long currentTimeMillis = this.clock.millis();
        if (this.exceededBatchSizeThreshold() || this.exceededWaitTimeThreshold(currentTimeMillis)) {
            try {
                this.httpClient.log(this.outputBuffer);
            }
            finally {
                this.outputBuffer.clear();
                this.timeoutDeadline = currentTimeMillis + this.batchWaitMillis;
            }
        }
        return workDone;
    }

    @Override
    public void onMessage(int msgTypeId, MutableDirectBuffer buffer, int index, int length) {
        if (msgTypeId == 5) {
            this.processMessage(buffer, index);
        }
    }

    @Override
    public String roleName() {
        return "ReadingLogBufferAndSendingHttp";
    }

    private boolean exceededWaitTimeThreshold(long currentTimeMillis) {
        return currentTimeMillis > this.timeoutDeadline & this.outputBuffer.getBytesPending() > 0;
    }

    private boolean exceededBatchSizeThreshold() {
        return (long)this.outputBuffer.getBytesPending() > this.batchSize;
    }

    private void processMessage(MutableDirectBuffer buffer, int index) {
        this.logBufferTranscoder.deserializeIntoByteBuf(buffer, index, this.outputBuffer);
    }
}

