/*
 * Decompiled with CFR 0.152.
 */
package pl.tkowalcz.tjahzi;

import java.nio.ByteBuffer;
import java.util.Map;
import pl.tkowalcz.tjahzi.org.agrona.concurrent.AtomicBuffer;

public class LogBufferSerializer {
    private final AtomicBuffer buffer;

    public LogBufferSerializer(AtomicBuffer buffer) {
        this.buffer = buffer;
    }

    public int calculateRequiredSizeAscii(Map<String, String> labels, String logLevelLabel, String logLevel, ByteBuffer line) {
        int logLineSize = 4 + line.remaining();
        int logLevelSize = this.calculateOptionalLabelSizeAscii(logLevelLabel, logLevel);
        int headerAndLabelsSize = this.calculateRequiredSizeAscii(labels);
        return headerAndLabelsSize + logLineSize + logLevelSize;
    }

    public void writeTo(int cursor, long timestamp, Map<String, String> labels, String logLevelLabel, String logLevel, ByteBuffer line) {
        cursor = this.writeHeader(cursor, timestamp, labels, logLevelLabel != null);
        cursor = this.writeLabels(cursor, labels);
        cursor = this.writeOptionalLabel(cursor, logLevelLabel, logLevel);
        this.writeLogLine(cursor, line);
    }

    private int writeHeader(int cursor, long timestamp, Map<String, String> labels, boolean hasLogLevelLabel) {
        this.buffer.putLong(cursor, timestamp);
        cursor += 8;
        int labelsCount = labels.size();
        if (hasLogLevelLabel) {
            ++labelsCount;
        }
        this.buffer.putInt(cursor, labelsCount);
        return cursor += 4;
    }

    private int writeLabels(int cursor, Map<String, String> labels) {
        for (Map.Entry<String, String> entry : labels.entrySet()) {
            cursor = this.writeLabel(cursor, entry.getKey(), entry.getValue());
        }
        return cursor;
    }

    private void writeLogLine(int cursor, ByteBuffer line) {
        this.buffer.putInt(cursor, line.remaining());
        this.buffer.putBytes(cursor += 4, line, line.remaining());
    }

    private int writeLabel(int cursor, String key, String value) {
        cursor += this.buffer.putStringAscii(cursor, key);
        cursor += this.buffer.putStringAscii(cursor, value);
        return cursor;
    }

    private int writeOptionalLabel(int cursor, String key, String value) {
        if (key != null) {
            cursor += this.buffer.putStringAscii(cursor, key);
            cursor += this.buffer.putStringAscii(cursor, value);
        }
        return cursor;
    }

    private int calculateRequiredSizeAscii(Map<String, String> labels) {
        int timestampSize = 8;
        int labelsCountSize = 4;
        int sum = timestampSize + labelsCountSize;
        for (Map.Entry<String, String> entry : labels.entrySet()) {
            sum += this.calculateLabelSizeAscii(entry.getKey(), entry.getValue());
        }
        return sum;
    }

    private int calculateOptionalLabelSizeAscii(String key, String value) {
        if (key == null) {
            return 0;
        }
        return 4 + key.length() + 4 + value.length();
    }

    private int calculateLabelSizeAscii(String key, String value) {
        return 4 + key.length() + 4 + value.length();
    }
}

