/*
 * Decompiled with CFR 0.152.
 */
package pl.tkowalcz.tjahzi;

import java.nio.ByteBuffer;
import java.util.Map;
import pl.tkowalcz.tjahzi.LogBufferAgent;
import pl.tkowalcz.tjahzi.LoggingSystem;
import pl.tkowalcz.tjahzi.http.NettyHttpClient;
import pl.tkowalcz.tjahzi.org.agrona.concurrent.AgentRunner;
import pl.tkowalcz.tjahzi.org.agrona.concurrent.SleepingMillisIdleStrategy;
import pl.tkowalcz.tjahzi.org.agrona.concurrent.UnsafeBuffer;
import pl.tkowalcz.tjahzi.org.agrona.concurrent.ringbuffer.ManyToOneRingBuffer;
import pl.tkowalcz.tjahzi.org.agrona.concurrent.ringbuffer.RingBufferDescriptor;
import pl.tkowalcz.tjahzi.stats.MonitoringModule;

public class TjahziInitializer {
    public static final int MIN_BUFFER_SIZE_BYTES = 0x100000;

    public LoggingSystem createLoggingSystem(NettyHttpClient httpClient, MonitoringModule monitoringModule, Map<String, String> staticLabels, long batchSizeBytes, long batchWaitMillis, int bufferSizeBytes, boolean offHeap) {
        bufferSizeBytes = TjahziInitializer.findNearestPowerOfTwo(bufferSizeBytes);
        ByteBuffer javaBuffer = this.allocateJavaBuffer(bufferSizeBytes, offHeap);
        ManyToOneRingBuffer logBuffer = new ManyToOneRingBuffer(new UnsafeBuffer(javaBuffer));
        LogBufferAgent agent = new LogBufferAgent(monitoringModule.getClock(), logBuffer, httpClient, batchSizeBytes, batchWaitMillis, staticLabels);
        AgentRunner runner = new AgentRunner(new SleepingMillisIdleStrategy(), monitoringModule::addAgentError, null, agent);
        return new LoggingSystem(logBuffer, runner, monitoringModule, httpClient);
    }

    public static boolean isCorrectSize(int bufferSize) {
        return bufferSize >= 0x100000 && Integer.bitCount(bufferSize) == 1;
    }

    static int findNearestPowerOfTwo(int bufferSize) {
        if (!TjahziInitializer.isCorrectSize(bufferSize)) {
            if (bufferSize < 0x100000) {
                return 0x100000;
            }
            long candidatePowerOfTwo = Long.highestOneBit(bufferSize) << 1;
            if (candidatePowerOfTwo + (long)RingBufferDescriptor.TRAILER_LENGTH >= Integer.MAX_VALUE) {
                return (int)(candidatePowerOfTwo >> 1);
            }
            return (int)candidatePowerOfTwo;
        }
        return bufferSize;
    }

    private ByteBuffer allocateJavaBuffer(int bufferSize, boolean offHeap) {
        int totalSize = bufferSize + RingBufferDescriptor.TRAILER_LENGTH;
        if (offHeap) {
            return ByteBuffer.allocateDirect(totalSize);
        }
        return ByteBuffer.allocate(totalSize);
    }
}

