/*
 * Decompiled with CFR 0.152.
 */
package pl.tkowalcz.tjahzi.http;

import java.util.function.LongSupplier;

public class ExponentialBackoffStrategy
implements LongSupplier {
    private final long maximumBackoffMillis;
    private final double multiplier;
    private long nextBackoff;

    public ExponentialBackoffStrategy(long initialBackoffMillis, long maximumBackoffMillis, double multiplier) {
        this.maximumBackoffMillis = maximumBackoffMillis;
        this.multiplier = multiplier;
        this.nextBackoff = initialBackoffMillis;
    }

    @Override
    public long getAsLong() {
        long result = this.nextBackoff;
        this.nextBackoff = (long)Math.min((double)this.nextBackoff * this.multiplier, (double)this.maximumBackoffMillis);
        return result;
    }

    public static ExponentialBackoffStrategy withDefault() {
        return new ExponentialBackoffStrategy(250L, 30000L, 3.0);
    }
}

