/*
 * Decompiled with CFR 0.152.
 */
package pl.tkowalcz.tjahzi.http;

import pl.tkowalcz.tjahzi.http.PipelinedHttpRequestTimer;
import pl.tkowalcz.tjahzi.http.RequestAndResponseHandler;
import pl.tkowalcz.tjahzi.io.netty.channel.Channel;
import pl.tkowalcz.tjahzi.io.netty.channel.ChannelInitializer;
import pl.tkowalcz.tjahzi.io.netty.channel.ChannelPipeline;
import pl.tkowalcz.tjahzi.io.netty.handler.codec.http.HttpClientCodec;
import pl.tkowalcz.tjahzi.io.netty.handler.codec.http.HttpContentDecompressor;
import pl.tkowalcz.tjahzi.io.netty.handler.codec.http.HttpObjectAggregator;
import pl.tkowalcz.tjahzi.io.netty.handler.ssl.SslContext;
import pl.tkowalcz.tjahzi.io.netty.handler.timeout.IdleStateHandler;
import pl.tkowalcz.tjahzi.stats.MonitoringModule;

class HttpClientInitializer
extends ChannelInitializer<Channel> {
    private static final int BYTES_IN_MEGABYTE = 0x100000;
    private static final int MAX_CONTENT_LENGTH = 0xA00000;
    private final MonitoringModule monitoringModule;
    private final RequestAndResponseHandler responseHandler;
    private final SslContext sslContext;
    private final int requestTimeoutMillis;
    private final int maxRequestsInFlight;

    HttpClientInitializer(MonitoringModule monitoringModule, SslContext sslContext, int requestTimeoutMillis, int maxRequestsInFlight) {
        this.monitoringModule = monitoringModule;
        this.responseHandler = new RequestAndResponseHandler(monitoringModule);
        this.sslContext = sslContext;
        this.requestTimeoutMillis = requestTimeoutMillis;
        this.maxRequestsInFlight = maxRequestsInFlight;
    }

    @Override
    protected void initChannel(Channel ch) {
        ChannelPipeline p = ch.pipeline();
        p.addLast(new IdleStateHandler(this.requestTimeoutMillis, 0, 60));
        if (this.sslContext != null) {
            p.addLast(this.sslContext.newHandler(ch.alloc()));
        }
        p.addLast(new HttpClientCodec());
        p.addLast(new HttpObjectAggregator(0xA00000));
        p.addLast(new HttpContentDecompressor());
        p.addLast(new PipelinedHttpRequestTimer(this.monitoringModule, this.maxRequestsInFlight));
        p.addLast(this.responseHandler);
    }
}

