/*
 * Decompiled with CFR 0.152.
 */
package pl.tkowalcz.tjahzi.log4j2;

import java.nio.ByteBuffer;
import java.util.function.BiConsumer;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.layout.ByteBufferDestination;
import org.apache.logging.log4j.core.layout.ByteBufferDestinationHelper;

public class ByteBufferDestinations
implements ByteBufferDestination {
    private static final ThreadLocal<ByteBufferDestinations> THREAD_LOCAL = ThreadLocal.withInitial(ByteBufferDestinations::new);
    private final ByteBuffer buffer = ByteBuffer.allocate(10240);
    private BiConsumer<LogEvent, ByteBuffer> drain;
    private LogEvent context;

    public static ByteBufferDestinations threadLocal() {
        ByteBufferDestinations result = THREAD_LOCAL.get();
        result.getByteBuffer().clear();
        return result;
    }

    public void drainRemaining() {
        if (this.buffer.hasRemaining()) {
            this.drain(this.buffer);
        }
    }

    public ByteBuffer getByteBuffer() {
        return this.buffer;
    }

    public ByteBuffer drain(ByteBuffer buf) {
        buf.flip();
        this.drain.accept(this.context, buf);
        buf.clear();
        return buf;
    }

    public void writeBytes(ByteBuffer data) {
        ByteBufferDestinationHelper.writeToUnsynchronized((ByteBuffer)data, (ByteBufferDestination)this);
    }

    public void writeBytes(byte[] data, int offset, int length) {
        ByteBufferDestinationHelper.writeToUnsynchronized((byte[])data, (int)offset, (int)length, (ByteBufferDestination)this);
    }

    public void initialize(BiConsumer<LogEvent, ByteBuffer> drain, LogEvent context) {
        this.context = context;
        this.drain = drain;
    }
}

