/*
 * Decompiled with CFR 0.152.
 */
package pl.tkowalcz.tjahzi.log4j2;

import java.util.regex.Pattern;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.config.plugins.PluginValue;
import org.apache.logging.log4j.status.StatusLogger;
import pl.tkowalcz.tjahzi.log4j2.Property;

@Plugin(name="label", category="Core", printObject=true)
public class Label
extends Property {
    private static final Logger LOGGER = StatusLogger.getLogger();
    private static final Pattern LABEL_NAME_PATTER = Pattern.compile("[a-zA-Z_][a-zA-Z0-9_]*");

    private Label(String name, String value) {
        super(name, value);
    }

    @PluginFactory
    public static Label createLabel(@PluginAttribute(value="name") String name, @PluginValue(value="value") String value) {
        if (name == null) {
            LOGGER.error("Property name cannot be null");
        }
        return new Label(name, value);
    }

    public boolean hasValidName() {
        return Label.hasValidName(this.getName());
    }

    public static boolean hasValidName(String label) {
        return LABEL_NAME_PATTER.matcher(label).matches();
    }
}

