/*
 * Decompiled with CFR 0.152.
 */
package pl.tkowalcz.tjahzi.log4j2;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.status.StatusLogger;
import pl.tkowalcz.tjahzi.github.GitHubDocs;
import pl.tkowalcz.tjahzi.log4j2.Label;
import pl.tkowalcz.tjahzi.log4j2.LabelsDescriptor;
import pl.tkowalcz.tjahzi.log4j2.Property;

public class LabelFactory {
    private static final Logger LOGGER = StatusLogger.getLogger();
    private static final Pattern DYNAMIC_LABEL_PATTERN = Pattern.compile("\\$\\{ctx:[^}:]+}");
    private static final Predicate<Map.Entry<String, String>> IS_DYNAMIC_LABEL = entry -> DYNAMIC_LABEL_PATTERN.matcher((CharSequence)entry.getValue()).find();
    private final String logLevelLabel;
    private final Label[] labels;

    public LabelFactory(String logLevelLabel, Label ... labels) {
        this.logLevelLabel = logLevelLabel;
        this.labels = labels;
    }

    public LabelsDescriptor convertLabelsDroppingInvalid() {
        this.detectAndLogDuplicateLabels();
        Map<String, String> allLabels = this.convertAndLogViolations();
        Map<String, String> dynamicLabels = allLabels.entrySet().stream().filter(IS_DYNAMIC_LABEL).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        Map<String, String> staticLabels = allLabels.entrySet().stream().filter(IS_DYNAMIC_LABEL.negate()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        String actualLogLevelLabel = LabelFactory.validateLogLevelLabel(this.logLevelLabel, staticLabels, dynamicLabels);
        return new LabelsDescriptor(actualLogLevelLabel, staticLabels, dynamicLabels);
    }

    private void detectAndLogDuplicateLabels() {
        List duplicatedLabels = Arrays.stream(this.labels).collect(Collectors.groupingBy(Property::getName, Collectors.counting())).entrySet().stream().filter(entry -> (Long)entry.getValue() > 1L).map(Map.Entry::getKey).collect(Collectors.toList());
        if (!duplicatedLabels.isEmpty()) {
            LOGGER.warn("There are duplicated labels which is not allowed by Loki. These labels will be deduplicated non-deterministically: {}", duplicatedLabels);
        }
    }

    private Map<String, String> convertAndLogViolations() {
        return Arrays.stream(this.labels).flatMap(label -> {
            if (label.hasValidName()) {
                return Stream.of(label);
            }
            LOGGER.error("Ignoring label '{}' - contains invalid characters. {}", (Object)label.getName(), (Object)GitHubDocs.LABEL_NAMING.getLogMessage());
            return Stream.of(new Label[0]);
        }).collect(Collectors.toMap(Property::getName, Property::getValue, (original, duplicate) -> duplicate));
    }

    private static String validateLogLevelLabel(String logLevelLabel, Map<String, String> staticLabels, Map<String, String> dynamicLabels) {
        if (logLevelLabel == null) {
            return null;
        }
        if (!Label.hasValidName(logLevelLabel)) {
            LOGGER.error("Ignoring log level label '{}' - contains invalid characters. {}", (Object)logLevelLabel, (Object)GitHubDocs.LABEL_NAMING.getLogMessage());
            return null;
        }
        if (staticLabels.remove(logLevelLabel) != null) {
            LOGGER.error("Log level label '{} conflicts with label defined in configuration - ignoring it.", (Object)logLevelLabel);
        }
        if (dynamicLabels.remove(logLevelLabel) != null) {
            LOGGER.error("Log level label '{} conflicts with label defined in configuration - ignoring it.", (Object)logLevelLabel);
        }
        return logLevelLabel;
    }
}

