/*
 * Decompiled with CFR 0.152.
 */
package pl.tkowalcz.tjahzi.org.agrona;

import java.nio.charset.StandardCharsets;
import pl.tkowalcz.tjahzi.org.agrona.AsciiNumberFormatException;

public final class AsciiEncoding {
    public static final byte[] MIN_INTEGER_VALUE = String.valueOf(Integer.MIN_VALUE).getBytes(StandardCharsets.US_ASCII);
    public static final byte[] MIN_LONG_VALUE = String.valueOf(Long.MIN_VALUE).getBytes(StandardCharsets.US_ASCII);
    public static final byte MINUS_SIGN = 45;
    public static final byte ZERO = 48;
    private static final byte[] MIN_INT_DIGITS = "2147483648".getBytes(StandardCharsets.US_ASCII);
    private static final byte[] MAX_INT_DIGITS = "2147483647".getBytes(StandardCharsets.US_ASCII);
    private static final byte[] MIN_LONG_DIGITS = "9223372036854775808".getBytes(StandardCharsets.US_ASCII);
    private static final byte[] MAX_LONG_DIGITS = "9223372036854775807".getBytes(StandardCharsets.US_ASCII);
    private static final int[] INT_ROUNDS = new int[]{9, 99, 999, 9999, 99999, 999999, 9999999, 99999999, 999999999, Integer.MAX_VALUE};
    private static final long[] LONG_ROUNDS = new long[]{9L, 99L, 999L, 9999L, 99999L, 999999L, 9999999L, 99999999L, 999999999L, 9999999999L, 99999999999L, 999999999999L, 9999999999999L, 99999999999999L, 999999999999999L, 9999999999999999L, 99999999999999999L, 999999999999999999L, Long.MAX_VALUE};

    private AsciiEncoding() {
    }

    public static int endOffset(int value) {
        int i = 0;
        while (value > INT_ROUNDS[i]) {
            ++i;
        }
        return i;
    }

    public static int endOffset(long value) {
        int i = 0;
        while (value > LONG_ROUNDS[i]) {
            ++i;
        }
        return i;
    }

    public static int getDigit(int index, byte value) {
        if (value < 48 || value > 57) {
            throw new AsciiNumberFormatException("'" + (char)value + "' is not a valid digit @ " + index);
        }
        return value - 48;
    }

    public static int getDigit(int index, char value) {
        if (value < '0' || value > '9') {
            throw new AsciiNumberFormatException("'" + value + "' is not a valid digit @ " + index);
        }
        return value - 48;
    }

    public static int parseIntAscii(CharSequence cs, int index, int length) {
        int i;
        if (length <= 1) {
            return AsciiEncoding.parseSingleDigit(cs, index, length);
        }
        boolean hasSign = cs.charAt(index) == '-';
        int endExclusive = index + length;
        int n = i = hasSign ? index + 1 : index;
        if (length >= 10) {
            AsciiEncoding.checkIntLimits(cs, index, length, i, hasSign);
        }
        int tally = 0;
        while (i < endExclusive) {
            tally = tally * 10 + AsciiEncoding.getDigit(i, cs.charAt(i));
            ++i;
        }
        if (hasSign) {
            tally = -tally;
        }
        return tally;
    }

    public static long parseLongAscii(CharSequence cs, int index, int length) {
        int i;
        if (length <= 1) {
            return AsciiEncoding.parseSingleDigit(cs, index, length);
        }
        boolean hasSign = cs.charAt(index) == '-';
        int endExclusive = index + length;
        int n = i = hasSign ? index + 1 : index;
        if (length >= 19) {
            AsciiEncoding.checkLongLimits(cs, index, length, i, hasSign);
        }
        long tally = 0L;
        while (i < endExclusive) {
            tally = tally * 10L + (long)AsciiEncoding.getDigit(i, cs.charAt(i));
            ++i;
        }
        if (hasSign) {
            tally = -tally;
        }
        return tally;
    }

    private static int parseSingleDigit(CharSequence cs, int index, int length) {
        if (1 == length) {
            return AsciiEncoding.getDigit(index, cs.charAt(index));
        }
        if (0 == length) {
            throw new AsciiNumberFormatException("'' is not a valid digit @ " + index);
        }
        throw new IndexOutOfBoundsException("length=" + length);
    }

    private static void checkIntLimits(CharSequence cs, int index, int length, int i, boolean hasSign) {
        if (10 == length) {
            if (!hasSign && AsciiEncoding.isOverflow(MAX_INT_DIGITS, cs, i)) {
                throw new AsciiNumberFormatException("int overflow parsing: " + cs.subSequence(index, index + length));
            }
        } else if (11 == length && hasSign) {
            if (AsciiEncoding.isOverflow(MIN_INT_DIGITS, cs, i)) {
                throw new AsciiNumberFormatException("int overflow parsing: " + cs.subSequence(index, index + length));
            }
        } else {
            throw new AsciiNumberFormatException("int overflow parsing: " + cs.subSequence(index, index + length));
        }
    }

    private static void checkLongLimits(CharSequence cs, int index, int length, int i, boolean hasSign) {
        if (19 == length) {
            if (!hasSign && AsciiEncoding.isOverflow(MAX_LONG_DIGITS, cs, i)) {
                throw new AsciiNumberFormatException("long overflow parsing: " + cs.subSequence(index, index + length));
            }
        } else if (20 == length && hasSign) {
            if (AsciiEncoding.isOverflow(MIN_LONG_DIGITS, cs, i)) {
                throw new AsciiNumberFormatException("long overflow parsing: " + cs.subSequence(index, index + length));
            }
        } else {
            throw new AsciiNumberFormatException("long overflow parsing: " + cs.subSequence(index, index + length));
        }
    }

    private static boolean isOverflow(byte[] limitDigits, CharSequence cs, int index) {
        int limitDigit;
        int digit;
        for (int i = 0; i < limitDigits.length && (digit = AsciiEncoding.getDigit(i, cs.charAt(index + i))) >= (limitDigit = limitDigits[i] - 48); ++i) {
            if (digit <= limitDigit) continue;
            return true;
        }
        return false;
    }
}

