/*
 * Decompiled with CFR 0.152.
 */
package pl.tkowalcz.tjahzi.log4j2.labels;

import java.util.regex.Pattern;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.config.plugins.PluginValue;
import org.apache.logging.log4j.status.StatusLogger;

@Plugin(name="label", category="Core", printObject=true)
public class Label {
    private static final Logger LOGGER = StatusLogger.getLogger();
    private static final Pattern LABEL_NAME_PATTER = Pattern.compile("[a-zA-Z_][a-zA-Z0-9_]*");
    private final String name;
    private final String value;
    private final String pattern;

    private Label(String name, String value, String pattern) {
        this.name = name;
        this.value = value;
        this.pattern = pattern;
    }

    @PluginFactory
    public static Label createLabel(@PluginAttribute(value="name") String name, @PluginValue(value="value") String value, @PluginValue(value="pattern") String pattern) {
        if (name == null) {
            LOGGER.error("Property name cannot be null");
        }
        if (pattern == null && value == null) {
            LOGGER.error("Property must have pattern or value specified");
        }
        return new Label(name, value, pattern);
    }

    public boolean hasValidName() {
        return Label.hasValidName(this.getName());
    }

    public String getName() {
        return this.name;
    }

    public String getPattern() {
        return this.pattern;
    }

    public String getValue() {
        return this.value;
    }

    public static boolean hasValidName(String label) {
        return LABEL_NAME_PATTER.matcher(label).matches();
    }

    public String toString() {
        return "Label{name='" + this.name + '\'' + ", pattern='" + this.pattern + '\'' + ", value='" + this.value + '\'' + '}';
    }
}

