/*
 * Decompiled with CFR 0.152.
 */
package pl.tkowalcz.tjahzi.http;

import java.nio.charset.Charset;
import pl.tkowalcz.tjahzi.io.netty.channel.ChannelDuplexHandler;
import pl.tkowalcz.tjahzi.io.netty.channel.ChannelHandler;
import pl.tkowalcz.tjahzi.io.netty.channel.ChannelHandlerContext;
import pl.tkowalcz.tjahzi.io.netty.channel.ChannelPromise;
import pl.tkowalcz.tjahzi.io.netty.handler.codec.http.FullHttpRequest;
import pl.tkowalcz.tjahzi.io.netty.handler.codec.http.FullHttpResponse;
import pl.tkowalcz.tjahzi.io.netty.handler.codec.http.HttpStatusClass;
import pl.tkowalcz.tjahzi.io.netty.handler.codec.http.HttpUtil;
import pl.tkowalcz.tjahzi.io.netty.util.ReferenceCountUtil;
import pl.tkowalcz.tjahzi.stats.MonitoringModule;

@ChannelHandler.Sharable
class RequestAndResponseHandler
extends ChannelDuplexHandler {
    private final MonitoringModule monitoringModule;

    RequestAndResponseHandler(MonitoringModule monitoringModule) {
        this.monitoringModule = monitoringModule;
    }

    @Override
    public void write(ChannelHandlerContext ctx, Object object, ChannelPromise promise) throws Exception {
        if (object instanceof FullHttpRequest) {
            int payloadSize = ((FullHttpRequest)object).content().readableBytes();
            this.monitoringModule.incrementSentHttpRequests(payloadSize);
        }
        super.write(ctx, object, promise);
    }

    @Override
    public void channelRead(ChannelHandlerContext ctx, Object object) {
        FullHttpResponse msg = (FullHttpResponse)object;
        this.monitoringModule.incrementHttpResponses();
        if (msg.status().codeClass() != HttpStatusClass.SUCCESS) {
            System.out.println(msg.content().toString(Charset.defaultCharset()));
            this.monitoringModule.incrementHttpErrors(msg.status().code(), msg.content().toString(Charset.defaultCharset()));
        }
        if (!HttpUtil.isKeepAlive(msg)) {
            ctx.close();
        }
        ReferenceCountUtil.release(msg);
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        this.monitoringModule.addPipelineError(cause);
    }

    @Override
    public void channelInactive(ChannelHandlerContext ctx) {
        this.monitoringModule.incrementChannelInactive();
    }
}

