/*
 * Decompiled with CFR 0.152.
 */
package pl.tkowalcz.tjahzi;

import java.io.IOException;
import pl.tkowalcz.tjahzi.LogBufferMessageHandler;
import pl.tkowalcz.tjahzi.OutputBuffer;
import pl.tkowalcz.tjahzi.TimeCappedBatchingStrategy;
import pl.tkowalcz.tjahzi.http.NettyHttpClient;
import pl.tkowalcz.tjahzi.org.agrona.concurrent.Agent;
import pl.tkowalcz.tjahzi.org.agrona.concurrent.ringbuffer.ManyToOneRingBuffer;

public class LogShipperAgent
implements Agent {
    public static final int MAX_MESSAGES_TO_RETRIEVE = 100;
    private final ManyToOneRingBuffer logBuffer;
    private final NettyHttpClient httpClient;
    private final OutputBuffer outputBuffer;
    private final LogBufferMessageHandler messageHandler;
    private final TimeCappedBatchingStrategy batchStrategy;

    public LogShipperAgent(TimeCappedBatchingStrategy batchStrategy, ManyToOneRingBuffer logBuffer, OutputBuffer outputBuffer, NettyHttpClient httpClient, LogBufferMessageHandler messageHandler) {
        this.batchStrategy = batchStrategy;
        this.logBuffer = logBuffer;
        this.httpClient = httpClient;
        this.messageHandler = messageHandler;
        this.outputBuffer = outputBuffer;
    }

    private int doWork(boolean isTerminating) throws IOException {
        int workDone = this.logBuffer.read(this.messageHandler, 100);
        if (isTerminating || this.batchStrategy.shouldProceed()) {
            try {
                this.httpClient.log(this.outputBuffer);
            }
            finally {
                this.outputBuffer.clear();
            }
        }
        return workDone;
    }

    @Override
    public int doWork() throws IOException {
        return this.doWork(false);
    }

    @Override
    public void onClose() {
        this.batchStrategy.initShutdown();
        int workDone = Integer.MAX_VALUE;
        do {
            try {
                workDone = this.doWork(true);
            }
            catch (Exception exception) {
                // empty catch block
            }
        } while (workDone != 0 && this.batchStrategy.shouldContinueShutdown());
    }

    @Override
    public String roleName() {
        return "LogShipper";
    }
}

