/*
 * Decompiled with CFR 0.152.
 */
package pl.tkowalcz.tjahzi.log4j2.labels;

import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.pattern.PatternParser;
import org.apache.logging.log4j.status.StatusLogger;
import pl.tkowalcz.tjahzi.github.GitHubDocs;
import pl.tkowalcz.tjahzi.log4j2.labels.Label;
import pl.tkowalcz.tjahzi.log4j2.labels.LabelPrinter;
import pl.tkowalcz.tjahzi.log4j2.labels.LabelPrinterFactory;
import pl.tkowalcz.tjahzi.log4j2.labels.LabelsDescriptor;
import pl.tkowalcz.tjahzi.log4j2.labels.Log4jAdapterLabelPrinter;

public class LabelFactory {
    private static final Logger LOGGER = StatusLogger.getLogger();
    private final String logLevelLabel;
    private final Label[] labels;
    private final PatternParser patternParser;

    public LabelFactory(Configuration configuration, String logLevelLabel, Label ... labels) {
        this.logLevelLabel = logLevelLabel;
        this.labels = labels;
        this.patternParser = new PatternParser(configuration, "Converter", null);
    }

    public LabelsDescriptor convertLabelsDroppingInvalid() {
        this.detectAndLogDuplicateLabels();
        Map<String, LabelPrinter> allLabels = this.convertAndLogViolations();
        HashMap<String, LabelPrinter> dynamicLabels = new HashMap<String, LabelPrinter>();
        allLabels.entrySet().stream().filter(entry -> !((LabelPrinter)entry.getValue()).isStatic()).forEach(entry -> dynamicLabels.put((String)entry.getKey(), (LabelPrinter)entry.getValue()));
        LinkedHashMap<String, String> staticLabels = new LinkedHashMap<String, String>();
        allLabels.entrySet().stream().filter(entry -> ((LabelPrinter)entry.getValue()).isStatic()).forEach(entry -> staticLabels.put((String)entry.getKey(), ((LabelPrinter)entry.getValue()).toStringWithoutEvent()));
        String actualLogLevelLabel = LabelFactory.validateLogLevelLabel(this.logLevelLabel, staticLabels, dynamicLabels);
        return new LabelsDescriptor(actualLogLevelLabel, staticLabels, dynamicLabels);
    }

    private void detectAndLogDuplicateLabels() {
        List duplicatedLabels = Arrays.stream(this.labels).collect(Collectors.groupingBy(Label::getName, Collectors.counting())).entrySet().stream().filter(entry -> (Long)entry.getValue() > 1L).map(Map.Entry::getKey).collect(Collectors.toList());
        if (!duplicatedLabels.isEmpty()) {
            LOGGER.warn("There are duplicated labels which is not allowed by Loki. These labels will be deduplicated non-deterministically: {}", duplicatedLabels);
        }
    }

    private Map<String, LabelPrinter> convertAndLogViolations() {
        return Arrays.stream(this.labels).flatMap(label -> {
            if (label.hasValidName()) {
                return Stream.of(label);
            }
            LOGGER.error("Ignoring label '{}' - contains invalid characters. {}", (Object)label.getName(), (Object)GitHubDocs.LABEL_NAMING.getLogMessage());
            return Stream.of(new Label[0]);
        }).collect(Collectors.toMap(Label::getName, this::toLabelOrLog4jPattern, (original, duplicate) -> duplicate));
    }

    private LabelPrinter toLabelOrLog4jPattern(Label label) {
        if (label.getPattern() != null) {
            return Log4jAdapterLabelPrinter.of(this.patternParser.parse(label.getPattern()));
        }
        return LabelPrinterFactory.parse(label);
    }

    private static String validateLogLevelLabel(String logLevelLabel, Map<String, ?> staticLabels, Map<String, ?> dynamicLabels) {
        if (logLevelLabel == null) {
            return null;
        }
        if (!Label.hasValidName(logLevelLabel)) {
            LOGGER.error("Ignoring log level label '{}' - contains invalid characters. {}", (Object)logLevelLabel, (Object)GitHubDocs.LABEL_NAMING.getLogMessage());
            return null;
        }
        if (staticLabels.remove(logLevelLabel) != null) {
            LOGGER.error("Log level label '{} conflicts with label defined in configuration - ignoring it.", (Object)logLevelLabel);
        }
        if (dynamicLabels.remove(logLevelLabel) != null) {
            LOGGER.error("Log level label '{} conflicts with label defined in configuration - ignoring it.", (Object)logLevelLabel);
        }
        return logLevelLabel;
    }
}

