/*
 * Decompiled with CFR 0.152.
 */
package pl.tkowalcz.tjahzi.http;

import java.io.Closeable;
import java.io.IOException;
import pl.tkowalcz.tjahzi.OutputBuffer;
import pl.tkowalcz.tjahzi.http.ClientConfiguration;
import pl.tkowalcz.tjahzi.http.HttpConnection;
import pl.tkowalcz.tjahzi.http.HttpHeadersFactory;
import pl.tkowalcz.tjahzi.http.Snappy;
import pl.tkowalcz.tjahzi.io.netty.buffer.ByteBuf;
import pl.tkowalcz.tjahzi.io.netty.buffer.PooledByteBufAllocator;
import pl.tkowalcz.tjahzi.io.netty.handler.codec.http.DefaultFullHttpRequest;
import pl.tkowalcz.tjahzi.io.netty.handler.codec.http.HttpHeaderNames;
import pl.tkowalcz.tjahzi.io.netty.handler.codec.http.HttpHeaders;
import pl.tkowalcz.tjahzi.io.netty.handler.codec.http.HttpMethod;
import pl.tkowalcz.tjahzi.io.netty.handler.codec.http.HttpVersion;
import pl.tkowalcz.tjahzi.io.netty.util.ReferenceCountUtil;
import pl.tkowalcz.tjahzi.stats.MonitoringModule;

public class NettyHttpClient
implements Closeable {
    public static final String PROTOBUF_MIME_TYPE = "application/x-protobuf";
    private final ClientConfiguration clientConfiguration;
    private final HttpHeaders headers;
    private final HttpConnection lokiConnection;
    private final Snappy snappy = new Snappy();

    public NettyHttpClient(ClientConfiguration clientConfiguration, MonitoringModule monitoringModule, String ... additionalHeaders) {
        this.clientConfiguration = clientConfiguration;
        this.headers = HttpHeadersFactory.createHeaders(clientConfiguration, additionalHeaders);
        this.lokiConnection = new HttpConnection(clientConfiguration, monitoringModule);
    }

    public void log(ByteBuf dataBuffer) {
        DefaultFullHttpRequest request = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.POST, this.clientConfiguration.getLogEndpoint(), dataBuffer);
        request.headers().add(this.headers).set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)PROTOBUF_MIME_TYPE).set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)dataBuffer.readableBytes()).set((CharSequence)HttpHeaderNames.HOST, (Object)this.clientConfiguration.getHost());
        this.lokiConnection.execute(request);
    }

    @Override
    public void close() {
        this.lokiConnection.close();
    }

    public void log(OutputBuffer outputBuffer) throws IOException {
        ByteBuf dataBuffer = outputBuffer.close();
        ByteBuf compressedBuffer = PooledByteBufAllocator.DEFAULT.buffer();
        try {
            this.snappy.encode(dataBuffer, compressedBuffer, dataBuffer.readableBytes());
        }
        catch (Exception e) {
            ReferenceCountUtil.safeRelease(compressedBuffer);
            throw e;
        }
        this.log(compressedBuffer);
    }
}

