/*
 * Decompiled with CFR 0.152.
 */
package pl.tkowalcz.tjahzi.log4j2;

import java.io.Serializable;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.util.Builder;
import org.apache.logging.log4j.status.StatusLogger;
import pl.tkowalcz.tjahzi.LoggingSystem;
import pl.tkowalcz.tjahzi.TjahziInitializer;
import pl.tkowalcz.tjahzi.github.GitHubDocs;
import pl.tkowalcz.tjahzi.http.ClientConfiguration;
import pl.tkowalcz.tjahzi.http.HttpClientFactory;
import pl.tkowalcz.tjahzi.http.NettyHttpClient;
import pl.tkowalcz.tjahzi.log4j2.Header;
import pl.tkowalcz.tjahzi.log4j2.LokiAppender;
import pl.tkowalcz.tjahzi.log4j2.labels.Label;
import pl.tkowalcz.tjahzi.log4j2.labels.LabelFactory;
import pl.tkowalcz.tjahzi.log4j2.labels.LabelsDescriptor;
import pl.tkowalcz.tjahzi.stats.MutableMonitoringModuleWrapper;
import pl.tkowalcz.tjahzi.stats.StandardMonitoringModule;

public class LokiAppenderBuilder<B extends LokiAppenderBuilder<B>>
extends AbstractAppender.Builder<B>
implements Builder<LokiAppender> {
    private static final Logger LOGGER = StatusLogger.getLogger();
    private static final int BYTES_IN_MEGABYTE = 0x100000;
    private static final int BYTES_IN_KILOBYTE = 1024;
    @PluginBuilderAttribute
    private String url;
    @PluginBuilderAttribute
    private String logEndpoint;
    @PluginBuilderAttribute
    private String host;
    @PluginBuilderAttribute
    private int port;
    @PluginBuilderAttribute
    private boolean useSSL;
    @PluginBuilderAttribute
    private boolean useDaemonThreads;
    @PluginBuilderAttribute
    private String username;
    @PluginBuilderAttribute
    private String password;
    @PluginBuilderAttribute
    private int connectTimeoutMillis = 5000;
    @PluginBuilderAttribute
    private int readTimeoutMillis = 60000;
    @PluginBuilderAttribute
    private int maxRetries = 3;
    @PluginBuilderAttribute
    private int bufferSizeMegabytes = 32;
    @PluginBuilderAttribute
    private boolean useOffHeapBuffer = true;
    @PluginBuilderAttribute
    private String logLevelLabel;
    @PluginBuilderAttribute
    private long batchSize = 102400L;
    @PluginBuilderAttribute
    private long batchWait = 5L;
    @PluginBuilderAttribute
    private long logShipperWakeupIntervalMillis = 10L;
    @PluginBuilderAttribute
    private int shutdownTimeoutSeconds = 10;
    @PluginBuilderAttribute
    private int maxLogLineSizeKilobytes = 10;
    @PluginBuilderAttribute
    private int maxRequestsInFlight = 100;
    @PluginElement(value="Headers")
    private Header[] headers;
    @PluginElement(value="Labels")
    private Label[] labels;

    public LokiAppender build() {
        ClientConfiguration configurationBuilder = ClientConfiguration.builder().withUrl(this.url).withLogEndpoint(this.logEndpoint).withHost(this.host).withPort(this.port).withUseSSL(this.useSSL).withUsername(this.username).withPassword(this.password).withConnectionTimeoutMillis(this.connectTimeoutMillis).withMaxRetries(this.maxRetries).withRequestTimeoutMillis(this.readTimeoutMillis).withMaxRequestsInFlight(this.maxRequestsInFlight).build();
        String[] additionalHeaders = (String[])Arrays.stream(this.headers).flatMap(header -> Stream.of(header.getName(), header.getValue())).toArray(String[]::new);
        MutableMonitoringModuleWrapper monitoringModuleWrapper = new MutableMonitoringModuleWrapper();
        monitoringModuleWrapper.setMonitoringModule(new StandardMonitoringModule());
        NettyHttpClient httpClient = HttpClientFactory.defaultFactory().getHttpClient(configurationBuilder, monitoringModuleWrapper, additionalHeaders);
        int bufferSizeBytes = this.getBufferSizeMegabytes() * 0x100000;
        if (!TjahziInitializer.isCorrectSize(bufferSizeBytes)) {
            LOGGER.warn("Invalid log buffer size {} - using nearest power of two greater than provided value, no less than 1MB. {}", (Object)bufferSizeBytes, (Object)GitHubDocs.LOG_BUFFER_SIZING.getLogMessage());
        }
        LabelFactory labelFactory = new LabelFactory(this.getConfiguration(), this.logLevelLabel, this.labels);
        LabelsDescriptor labelsDescriptor = labelFactory.convertLabelsDroppingInvalid();
        this.logLevelLabel = labelsDescriptor.getLogLevelLabel();
        LoggingSystem loggingSystem = new TjahziInitializer().createLoggingSystem(httpClient, monitoringModuleWrapper, labelsDescriptor.getStaticLabels(), this.batchSize, TimeUnit.SECONDS.toMillis(this.batchWait), bufferSizeBytes, this.logShipperWakeupIntervalMillis, TimeUnit.SECONDS.toMillis(this.shutdownTimeoutSeconds), this.isUseOffHeapBuffer(), this.useDaemonThreads);
        int maxLogLineSizeBytes = Math.toIntExact(this.getMaxLogLineSizeKilobytes() * 1024L);
        return new LokiAppender(this.getName(), (Layout<? extends Serializable>)this.getLayout(), this.getFilter(), this.isIgnoreExceptions(), this.getPropertyArray(), this.logLevelLabel, labelsDescriptor.getDynamicLabels(), maxLogLineSizeBytes, loggingSystem, monitoringModuleWrapper);
    }

    public String getHost() {
        return this.host;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getLogEndpoint() {
        return this.logEndpoint;
    }

    public void setLogEndpoint(String logEndpoint) {
        this.logEndpoint = logEndpoint;
    }

    public boolean isUseSSL() {
        return this.useSSL;
    }

    public void setUseSSL(boolean useSSL) {
        this.useSSL = useSSL;
    }

    public boolean isUseDaemonThreads() {
        return this.useDaemonThreads;
    }

    public void setUseDaemonThreads(boolean useDaemonThreads) {
        this.useDaemonThreads = useDaemonThreads;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public int getConnectTimeoutMillis() {
        return this.connectTimeoutMillis;
    }

    public int getReadTimeoutMillis() {
        return this.readTimeoutMillis;
    }

    public Header[] getHeaders() {
        return this.headers;
    }

    public B setHost(String host) {
        this.host = host;
        return (B)((Object)((LokiAppenderBuilder)this.asBuilder()));
    }

    public B setConnectTimeoutMillis(int connectTimeoutMillis) {
        this.connectTimeoutMillis = connectTimeoutMillis;
        return (B)((Object)((LokiAppenderBuilder)this.asBuilder()));
    }

    public B setReadTimeoutMillis(int readTimeoutMillis) {
        this.readTimeoutMillis = readTimeoutMillis;
        return (B)((Object)((LokiAppenderBuilder)this.asBuilder()));
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public int getMaxRetries() {
        return this.maxRetries;
    }

    public void setMaxRetries(int maxRetries) {
        this.maxRetries = maxRetries;
    }

    public int getBufferSizeMegabytes() {
        return this.bufferSizeMegabytes;
    }

    public void setBufferSizeMegabytes(int bufferSizeMegabytes) {
        this.bufferSizeMegabytes = bufferSizeMegabytes;
    }

    public boolean isUseOffHeapBuffer() {
        return this.useOffHeapBuffer;
    }

    public void setUseOffHeapBuffer(boolean useOffHeapBuffer) {
        this.useOffHeapBuffer = useOffHeapBuffer;
    }

    public String getLogLevelLabel() {
        return this.logLevelLabel;
    }

    public void setLogLevelLabel(String logLevelLabel) {
        this.logLevelLabel = logLevelLabel;
    }

    public long getBatchSize() {
        return this.batchSize;
    }

    public void setBatchSize(long batchSize) {
        this.batchSize = batchSize;
    }

    public long getBatchWait() {
        return this.batchWait;
    }

    public void setBatchWait(long batchWait) {
        this.batchWait = batchWait;
    }

    public long getLogShipperWakeupIntervalMillis() {
        return this.logShipperWakeupIntervalMillis;
    }

    public void setLogShipperWakeupIntervalMillis(long logShipperWakeupIntervalMillis) {
        this.logShipperWakeupIntervalMillis = logShipperWakeupIntervalMillis;
    }

    public int getShutdownTimeoutSeconds() {
        return this.shutdownTimeoutSeconds;
    }

    public void setShutdownTimeoutSeconds(int shutdownTimeoutSeconds) {
        this.shutdownTimeoutSeconds = shutdownTimeoutSeconds;
    }

    public void setMaxLogLineSizeKilobytes(int maxLogLineSizeKilobytes) {
        this.maxLogLineSizeKilobytes = maxLogLineSizeKilobytes;
    }

    public long getMaxLogLineSizeKilobytes() {
        return this.maxLogLineSizeKilobytes;
    }

    public void setMaxRequestsInFlight(int maxRequestsInFlight) {
        this.maxRequestsInFlight = maxRequestsInFlight;
    }

    public int getMaxRequestsInFlight() {
        return this.maxRequestsInFlight;
    }

    public void setHeaders(Header[] headers) {
        this.headers = headers;
    }

    public Label[] getLabels() {
        return this.labels;
    }

    public void setLabels(Label[] labels) {
        this.labels = labels;
    }
}

