/*
 * Decompiled with CFR 0.152.
 */
package pl.tkowalcz.tjahzi.stats;

import java.time.Clock;

public class TimingRingBuffer {
    private final Clock clock;
    private final long[] times;
    private int readPosition;
    private int writePosition;

    public TimingRingBuffer(Clock clock, int maxRequestsInFlight) {
        this.clock = clock;
        this.times = new long[maxRequestsInFlight];
    }

    public void record() {
        int index = Math.abs(this.writePosition % this.times.length);
        ++this.writePosition;
        this.times[index] = this.clock.millis();
    }

    public long measure() {
        int index = Math.abs(this.readPosition % this.times.length);
        ++this.readPosition;
        return this.clock.millis() - this.times[index];
    }
}

