/*
 * Decompiled with CFR 0.152.
 */
package pl.tkowalcz.tjahzi;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import pl.tkowalcz.tjahzi.LabelSerializer;
import pl.tkowalcz.tjahzi.org.agrona.concurrent.AtomicBuffer;

public class LogBufferSerializer {
    private final AtomicBuffer buffer;

    public LogBufferSerializer(AtomicBuffer buffer) {
        this.buffer = buffer;
    }

    public int calculateRequiredSize(LabelSerializer labelSerializer, ByteBuffer line) {
        int logLineSize = 4 + line.remaining();
        int nanosecondResolutionTimestampSize = 16;
        int labelsCountSize = 4;
        int headerAndLabelsSize = nanosecondResolutionTimestampSize + labelsCountSize + labelSerializer.sizeBytes();
        return headerAndLabelsSize + logLineSize;
    }

    public void writeTo(int cursor, long epochMillisecond, long nanoOfMillisecond, LabelSerializer serializedLabels, ByteBuffer line) {
        cursor = this.writeHeader(cursor, epochMillisecond, nanoOfMillisecond, serializedLabels);
        cursor = this.writeLabels(cursor, serializedLabels);
        this.writeLogLine(cursor, line);
    }

    private int writeHeader(int cursor, long epochMillisecond, long nanoOfMillisecond, LabelSerializer serializedLabels) {
        this.buffer.putLong(cursor, epochMillisecond, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putLong(cursor += 8, nanoOfMillisecond, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putInt(cursor += 8, serializedLabels.getLabelsCount(), ByteOrder.LITTLE_ENDIAN);
        return cursor += 4;
    }

    private int writeLabels(int cursor, LabelSerializer serializedLabels) {
        int remaining = serializedLabels.sizeBytes();
        this.buffer.putBytes(cursor, serializedLabels.getBuffer(), 0, remaining);
        return cursor + remaining;
    }

    private void writeLogLine(int cursor, ByteBuffer line) {
        this.buffer.putInt(cursor, line.remaining(), ByteOrder.LITTLE_ENDIAN);
        this.buffer.putBytes(cursor += 4, line, line.remaining());
    }
}

