/*
 * Decompiled with CFR 0.152.
 */
package pl.tkowalcz.tjahzi.stats;

import java.util.function.Consumer;
import pl.tkowalcz.tjahzi.stats.StandardMonitoringModule;

public class LoggingMonitoringModule
extends StandardMonitoringModule {
    private final Consumer<String> logger;

    public LoggingMonitoringModule(Consumer<String> logger) {
        this.logger = logger;
    }

    @Override
    public void addAgentError(Throwable throwable) {
        super.addAgentError(throwable);
        this.logger.accept("[Tjahzi] Internal error occurred: " + throwable.getMessage() + ".");
    }

    @Override
    public void addPipelineError(Throwable cause) {
        super.addPipelineError(cause);
        this.logger.accept("[Tjahzi] Pipeline error occurred: " + cause.getMessage() + ".");
    }

    @Override
    public void incrementDroppedPuts(Throwable throwable) {
        super.incrementDroppedPuts(throwable);
        this.logger.accept("[Tjahzi] Dropped log entries due to error: " + throwable.getMessage() + ".");
    }

    @Override
    public void incrementRetriedHttpRequests() {
        super.incrementRetriedHttpRequests();
        this.logger.accept("[Tjahzi] Retrying failed http request.");
    }

    @Override
    public void incrementHttpErrors(int status, String message) {
        super.incrementHttpErrors(status, message);
        this.logger.accept("[Tjahzi] HTTP error occurred - status: " + status + ", message: " + message + ".");
    }

    @Override
    public void incrementFailedHttpRequests() {
        super.incrementFailedHttpRequests();
        this.logger.accept("[Tjahzi] HTTP request failed.");
    }

    @Override
    public void incrementChannelInactive() {
        super.incrementChannelInactive();
        this.logger.accept("[Tjahzi] Connection channel became inactive.");
    }

    @Override
    public void onClose() {
        super.onClose();
        this.logger.accept("[Tjahzi] Appender is being closed.");
    }
}

