/*
 * Decompiled with CFR 0.152.
 */
package pl.tkowalcz.tjahzi;

import java.nio.ByteOrder;
import pl.tkowalcz.tjahzi.org.agrona.DirectBuffer;
import pl.tkowalcz.tjahzi.org.agrona.ExpandableArrayBuffer;
import pl.tkowalcz.tjahzi.org.agrona.concurrent.AtomicBuffer;

public class LabelSerializer {
    private final ExpandableArrayBuffer buffer = new ExpandableArrayBuffer();
    private int cursor;
    private int labelsCount;
    private int lastSizePosition;

    public void clear() {
        this.cursor = 0;
        this.labelsCount = 0;
    }

    public int sizeBytes() {
        return this.cursor;
    }

    public int getLabelsCount() {
        return this.labelsCount;
    }

    public LabelSerializer appendLabelName(String key) {
        this.cursor += this.buffer.putStringAscii(this.cursor, key, ByteOrder.LITTLE_ENDIAN);
        ++this.labelsCount;
        return this;
    }

    public LabelSerializer startAppendingLabelValue() {
        this.lastSizePosition = this.cursor;
        this.cursor += 4;
        return this;
    }

    public LabelSerializer appendPartialLabelValue(CharSequence value) {
        this.cursor += this.buffer.putStringWithoutLengthAscii(this.cursor, value);
        return this;
    }

    public LabelSerializer finishAppendingLabelValue() {
        this.buffer.putInt(this.lastSizePosition, this.cursor - this.lastSizePosition - 4, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public LabelSerializer appendLabel(String key, String value) {
        this.appendLabelName(key);
        this.startAppendingLabelValue();
        this.appendPartialLabelValue(value);
        this.finishAppendingLabelValue();
        return this;
    }

    public DirectBuffer getBuffer() {
        return this.buffer;
    }

    public boolean equals(Object o) {
        if (o instanceof LabelSerializer) {
            LabelSerializer that = (LabelSerializer)o;
            if (this.cursor != that.cursor) {
                return false;
            }
            byte[] thisArray = this.buffer.byteArray();
            byte[] thatArray = that.buffer.byteArray();
            for (int i = 0; i < this.cursor; ++i) {
                if (thisArray[i] == thatArray[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int writeLabels(AtomicBuffer target, int targetCursor) {
        int remaining = this.sizeBytes();
        target.putInt(targetCursor, remaining, ByteOrder.LITTLE_ENDIAN);
        target.putInt(targetCursor += 4, this.labelsCount, ByteOrder.LITTLE_ENDIAN);
        target.putBytes(targetCursor += 4, this.buffer, 0, remaining);
        return targetCursor + remaining;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        for (int index = 0; index < this.cursor; index += this.buffer.getStringAscii(index, result, ByteOrder.LITTLE_ENDIAN) + 4) {
        }
        return result.toString();
    }
}

