/*
 * Decompiled with CFR 0.152.
 */
package pl.tkowalcz.tjahzi;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Map;
import pl.tkowalcz.tjahzi.OutputBuffer;
import pl.tkowalcz.tjahzi.StructuredMetadataPointer;
import pl.tkowalcz.tjahzi.io.netty.buffer.ByteBuf;
import pl.tkowalcz.tjahzi.io.netty.buffer.Unpooled;
import pl.tkowalcz.tjahzi.org.agrona.DirectBuffer;
import pl.tkowalcz.tjahzi.org.agrona.concurrent.AtomicBuffer;
import pl.tkowalcz.tjahzi.utils.TextBuilder;
import pl.tkowalcz.tjahzi.utils.TextBuilders;

public class LogBufferTranscoder {
    private final Map<String, String> staticLabels;
    private final String staticLabelsString;
    private final ByteBuf logLineHolder;
    private final StructuredMetadataPointer structuredMetadataPointer = new StructuredMetadataPointer();

    public LogBufferTranscoder(Map<String, String> staticLabels, AtomicBuffer buffer) {
        this.staticLabels = staticLabels;
        this.staticLabelsString = LogBufferTranscoder.buildLabelsStringIncludingStatic(staticLabels, "", TextBuilders.threadLocal().append("{ ")).toString();
        ByteBuffer byteBuffer = buffer.byteBuffer();
        this.logLineHolder = Unpooled.wrappedBuffer(byteBuffer);
    }

    public void deserializeIntoByteBuf(DirectBuffer buffer, int index, OutputBuffer outputBuffer) {
        long epochMillisecond = buffer.getLong(index, ByteOrder.LITTLE_ENDIAN);
        long nanoOfMillisecond = buffer.getLong(index += 8, ByteOrder.LITTLE_ENDIAN);
        index += 8;
        TextBuilder labelsBuilder = TextBuilders.threadLocal();
        labelsBuilder.append("{ ");
        index = LogBufferTranscoder.readLabels(buffer, index, labelsBuilder);
        CharSequence actualLabels = LogBufferTranscoder.buildLabelsStringIncludingStatic(this.staticLabels, this.staticLabelsString, labelsBuilder);
        int size = buffer.getInt(index, ByteOrder.LITTLE_ENDIAN);
        int structuredMetadataPosition = index += 4;
        this.structuredMetadataPointer.wrap(buffer, structuredMetadataPosition, size);
        this.logLineHolder.readerIndex(index += size + 4);
        outputBuffer.addLogLine(actualLabels, epochMillisecond, nanoOfMillisecond, this.structuredMetadataPointer, this.logLineHolder);
    }

    private static int readLabels(DirectBuffer buffer, int index, TextBuilder labelsBuilder) {
        int labelsSizeIgnored = buffer.getInt(index, ByteOrder.LITTLE_ENDIAN);
        int labelsCount = buffer.getInt(index += 4, ByteOrder.LITTLE_ENDIAN);
        index += 4;
        for (int i = 0; i < labelsCount; ++i) {
            index += buffer.getStringAscii(index, labelsBuilder, ByteOrder.LITTLE_ENDIAN) + 4;
            labelsBuilder.append("=").append("\"");
            index += buffer.getStringAscii(index, labelsBuilder, ByteOrder.LITTLE_ENDIAN) + 4;
            labelsBuilder.append("\",");
        }
        return index;
    }

    private static CharSequence buildLabelsStringIncludingStatic(Map<String, String> staticLabels, String staticLabelsString, TextBuilder labels) {
        if (labels.length() == 0) {
            return staticLabelsString;
        }
        staticLabels.forEach((key, value) -> labels.append((CharSequence)key).append("=").append("\"").append((CharSequence)value).append("\","));
        labels.setCharAt(labels.length() - 1, '}');
        return labels;
    }
}

