/*
 * Decompiled with CFR 0.152.
 */
package pl.tkowalcz.tjahzi;

import java.io.Closeable;
import java.util.function.Consumer;
import pl.tkowalcz.tjahzi.TjahziLogger;
import pl.tkowalcz.tjahzi.org.agrona.concurrent.AgentRunner;
import pl.tkowalcz.tjahzi.org.agrona.concurrent.ringbuffer.ManyToOneRingBuffer;
import pl.tkowalcz.tjahzi.stats.MonitoringModule;

public class LoggingSystem {
    private final ManyToOneRingBuffer logBuffer;
    private final AgentRunner runner;
    private final MonitoringModule monitoringModule;
    private final boolean useDaemonThreads;
    private final Closeable[] resourcesToCleanup;

    public LoggingSystem(ManyToOneRingBuffer logBuffer, AgentRunner runner, MonitoringModule monitoringModule, boolean useDaemonThreads, Closeable ... resourcesToCleanup) {
        this.logBuffer = logBuffer;
        this.runner = runner;
        this.monitoringModule = monitoringModule;
        this.useDaemonThreads = useDaemonThreads;
        this.resourcesToCleanup = resourcesToCleanup;
    }

    public TjahziLogger createLogger() {
        return new TjahziLogger(this.logBuffer, this.monitoringModule);
    }

    public void start() {
        AgentRunner.startOnThread(this.runner, runnable -> {
            Thread result = new Thread(runnable);
            result.setDaemon(this.useDaemonThreads);
            return result;
        });
    }

    public void close(int retryCloseTimeoutMs, Consumer<Thread> closeFailAction) {
        this.runner.close(retryCloseTimeoutMs, closeFailAction);
        for (Closeable resource : this.resourcesToCleanup) {
            try {
                resource.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public int getLogBufferSize() {
        return this.logBuffer.capacity();
    }

    public int getLogBufferByteRemainsSize() {
        return this.logBuffer.size();
    }
}

