/*
 * Decompiled with CFR 0.152.
 */
package pl.tkowalcz.tjahzi.http;

import javax.net.ssl.SSLException;
import pl.tkowalcz.tjahzi.http.ClientConfiguration;
import pl.tkowalcz.tjahzi.http.HttpClientInitializer;
import pl.tkowalcz.tjahzi.io.netty.bootstrap.Bootstrap;
import pl.tkowalcz.tjahzi.io.netty.buffer.PooledByteBufAllocator;
import pl.tkowalcz.tjahzi.io.netty.channel.ChannelFuture;
import pl.tkowalcz.tjahzi.io.netty.channel.ChannelOption;
import pl.tkowalcz.tjahzi.io.netty.channel.EventLoopGroup;
import pl.tkowalcz.tjahzi.io.netty.channel.socket.nio.NioSocketChannel;
import pl.tkowalcz.tjahzi.io.netty.handler.ssl.SslContext;
import pl.tkowalcz.tjahzi.io.netty.handler.ssl.SslContextBuilder;
import pl.tkowalcz.tjahzi.io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import pl.tkowalcz.tjahzi.stats.MonitoringModule;

public class BootstrapUtil {
    public static ChannelFuture initConnection(EventLoopGroup group, ClientConfiguration clientConfiguration, MonitoringModule monitoringModule) {
        Bootstrap bootstrap = new Bootstrap();
        SslContext sslContext = null;
        if (clientConfiguration.isUseSSL()) {
            sslContext = BootstrapUtil.createSslContext();
        }
        return ((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)bootstrap.group(group)).option(ChannelOption.ALLOCATOR, PooledByteBufAllocator.DEFAULT)).option(ChannelOption.SO_KEEPALIVE, true)).option(ChannelOption.TCP_NODELAY, false)).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, clientConfiguration.getConnectionTimeoutMillis())).channel(NioSocketChannel.class)).handler(new HttpClientInitializer(monitoringModule, sslContext, clientConfiguration.getHost(), clientConfiguration.getPort(), clientConfiguration.getRequestTimeoutMillis(), clientConfiguration.getMaxRequestsInFlight()))).remoteAddress(clientConfiguration.getHost(), clientConfiguration.getPort()).connect();
    }

    private static SslContext createSslContext() {
        try {
            return SslContextBuilder.forClient().trustManager(InsecureTrustManagerFactory.INSTANCE).build();
        }
        catch (SSLException e) {
            throw new RuntimeException(e);
        }
    }
}

