/*
 * Decompiled with CFR 0.152.
 */
package pl.tkowalcz.tjahzi.log4j2.labels;

import java.util.regex.Pattern;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.status.StatusLogger;

public abstract class LabelBase {
    private static final Logger LOGGER = StatusLogger.getLogger();
    private static final Pattern LABEL_NAME_PATTER = Pattern.compile("[a-zA-Z_][a-zA-Z0-9_]*");
    private final String name;
    private final String value;
    private final String pattern;

    LabelBase(String name, String value, String pattern) {
        this.name = name;
        this.value = value;
        this.pattern = pattern;
        if (name == null) {
            LOGGER.error("Property name cannot be null");
        }
        if (pattern == null && value == null) {
            LOGGER.error("Property '{}' must have pattern or value specified", (Object)name);
        }
    }

    public boolean hasValidName() {
        return LabelBase.hasValidName(this.getName());
    }

    public String getName() {
        return this.name;
    }

    public String getPattern() {
        return this.pattern;
    }

    public String getValue() {
        return this.value;
    }

    public static boolean hasValidName(String label) {
        return LABEL_NAME_PATTER.matcher(label).matches();
    }
}

