/*
 * Decompiled with CFR 0.152.
 */
package pl.tkowalcz.tjahzi.org.agrona;

import java.nio.ByteBuffer;
import java.util.Arrays;
import pl.tkowalcz.tjahzi.org.agrona.AbstractMutableDirectBuffer;
import pl.tkowalcz.tjahzi.org.agrona.BufferUtil;
import pl.tkowalcz.tjahzi.org.agrona.DirectBuffer;

public class ExpandableArrayBuffer
extends AbstractMutableDirectBuffer {
    public static final int MAX_ARRAY_LENGTH = 0x7FFFFFF7;
    public static final int INITIAL_CAPACITY = 128;

    public ExpandableArrayBuffer() {
        this(128);
    }

    public ExpandableArrayBuffer(int initialCapacity) {
        this.byteArray = new byte[initialCapacity];
        this.capacity = initialCapacity;
        this.addressOffset = BufferUtil.ARRAY_BASE_OFFSET;
    }

    @Override
    public void wrap(byte[] buffer) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void wrap(byte[] buffer, int offset, int length) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void wrap(ByteBuffer buffer) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void wrap(ByteBuffer buffer, int offset, int length) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void wrap(DirectBuffer buffer) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void wrap(DirectBuffer buffer, int offset, int length) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void wrap(long address, int length) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ByteBuffer byteBuffer() {
        return null;
    }

    @Override
    public boolean isExpandable() {
        return true;
    }

    @Override
    public int wrapAdjustment() {
        return 0;
    }

    @Override
    public void checkLimit(int limit) {
        this.ensureCapacity(limit, 0);
    }

    public String toString() {
        return "ExpandableArrayBuffer{, capacity=" + this.capacity + ", byteArray=" + (null == this.byteArray ? "null" : "byte[" + this.byteArray.length + "]") + '}';
    }

    @Override
    protected final void ensureCapacity(int index, int length) {
        if (index < 0 || length < 0) {
            throw new IndexOutOfBoundsException("negative value: index=" + index + " length=" + length);
        }
        long resultingPosition = (long)index + (long)length;
        if (resultingPosition > (long)this.capacity) {
            if (resultingPosition > 0x7FFFFFF7L) {
                throw new IndexOutOfBoundsException("index=" + index + " length=" + length + " maxCapacity=" + 0x7FFFFFF7);
            }
            int newCapacity = ExpandableArrayBuffer.calculateExpansion(this.capacity, resultingPosition);
            this.byteArray = Arrays.copyOf(this.byteArray, newCapacity);
            this.capacity = newCapacity;
        }
    }

    private static int calculateExpansion(int currentLength, long requiredLength) {
        long value = Math.max(currentLength, 2);
        while (value < requiredLength) {
            if ((value += value >> 1) <= 0x7FFFFFF7L) continue;
            value = 0x7FFFFFF7L;
        }
        return (int)value;
    }
}

