/*
 * Decompiled with CFR 0.152.
 */
package pl.tkowalcz.tjahzi;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import pl.tkowalcz.tjahzi.LabelSerializer;
import pl.tkowalcz.tjahzi.org.agrona.concurrent.AtomicBuffer;

public class LogBufferSerializer {
    private final AtomicBuffer buffer;

    public LogBufferSerializer(AtomicBuffer buffer) {
        this.buffer = buffer;
    }

    public int calculateRequiredSize(LabelSerializer labelSerializer, LabelSerializer structuredMetadata, ByteBuffer line) {
        int logLineSize = 4 + line.remaining();
        int nanosecondResolutionTimestampSize = 16;
        int labelsCountSize = 8;
        int headerAndLabelsSize = nanosecondResolutionTimestampSize + labelsCountSize + labelSerializer.sizeBytes();
        int structuredMetadataSize = structuredMetadata.sizeBytes() + 4 + 4;
        return headerAndLabelsSize + logLineSize + structuredMetadataSize;
    }

    public void writeTo(int cursor, long epochMillisecond, long nanoOfMillisecond, LabelSerializer serializedLabels, LabelSerializer structuredMetadata, ByteBuffer line) {
        cursor = this.writeHeader(cursor, epochMillisecond, nanoOfMillisecond);
        cursor = serializedLabels.writeLabels(this.buffer, cursor);
        cursor = structuredMetadata.writeLabels(this.buffer, cursor);
        this.writeLogLine(cursor, line);
    }

    private int writeHeader(int cursor, long epochMillisecond, long nanoOfMillisecond) {
        this.buffer.putLong(cursor, epochMillisecond, ByteOrder.LITTLE_ENDIAN);
        this.buffer.putLong(cursor += 8, nanoOfMillisecond, ByteOrder.LITTLE_ENDIAN);
        return cursor += 8;
    }

    private void writeLogLine(int cursor, ByteBuffer line) {
        this.buffer.putInt(cursor, line.remaining(), ByteOrder.LITTLE_ENDIAN);
        this.buffer.putBytes(cursor += 4, line, line.remaining());
    }
}

