/*
 * Decompiled with CFR 0.152.
 */
package pl.tkowalcz.tjahzi;

import java.nio.ByteBuffer;
import pl.tkowalcz.tjahzi.LabelSerializer;
import pl.tkowalcz.tjahzi.LogBufferSerializer;
import pl.tkowalcz.tjahzi.org.agrona.concurrent.ringbuffer.ManyToOneRingBuffer;
import pl.tkowalcz.tjahzi.stats.MonitoringModule;

public class TjahziLogger {
    public static final int LOG_MESSAGE_TYPE_ID = 5;
    private final ManyToOneRingBuffer logBuffer;
    private final MonitoringModule monitoringModule;
    private final LogBufferSerializer serializer;

    public TjahziLogger(ManyToOneRingBuffer logBuffer, MonitoringModule monitoringModule) {
        this.logBuffer = logBuffer;
        this.monitoringModule = monitoringModule;
        this.serializer = new LogBufferSerializer(logBuffer.buffer());
    }

    public TjahziLogger log(long epochMillisecond, long nanoOfMillisecond, LabelSerializer serializedLabels, LabelSerializer structuredMetadata, ByteBuffer line) {
        int requiredSize = this.serializer.calculateRequiredSize(serializedLabels, structuredMetadata, line);
        int claim = this.logBuffer.tryClaim(5, requiredSize);
        if (claim > 0) {
            this.putMessageOnRing(epochMillisecond, nanoOfMillisecond, serializedLabels, structuredMetadata, line, claim);
        } else {
            this.monitoringModule.incrementDroppedPuts();
        }
        return this;
    }

    private void putMessageOnRing(long epochMillisecond, long nanoOfMillisecond, LabelSerializer serializedLabels, LabelSerializer structuredMetadata, ByteBuffer line, int claim) {
        try {
            this.serializer.writeTo(claim, epochMillisecond, nanoOfMillisecond, serializedLabels, structuredMetadata, line);
            this.logBuffer.commit(claim);
        }
        catch (Throwable t) {
            this.logBuffer.abort(claim);
            this.monitoringModule.incrementDroppedPuts(t);
        }
    }
}

