/*
 * Decompiled with CFR 0.152.
 */
package pl.tkowalcz.tjahzi.http;

import java.io.FileInputStream;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import javax.net.ssl.SSLException;
import javax.net.ssl.TrustManagerFactory;
import pl.tkowalcz.tjahzi.http.ClientConfiguration;
import pl.tkowalcz.tjahzi.http.HttpClientInitializer;
import pl.tkowalcz.tjahzi.io.netty.bootstrap.Bootstrap;
import pl.tkowalcz.tjahzi.io.netty.buffer.PooledByteBufAllocator;
import pl.tkowalcz.tjahzi.io.netty.channel.ChannelFuture;
import pl.tkowalcz.tjahzi.io.netty.channel.ChannelOption;
import pl.tkowalcz.tjahzi.io.netty.channel.EventLoopGroup;
import pl.tkowalcz.tjahzi.io.netty.channel.socket.nio.NioSocketChannel;
import pl.tkowalcz.tjahzi.io.netty.handler.ssl.SslContext;
import pl.tkowalcz.tjahzi.io.netty.handler.ssl.SslContextBuilder;
import pl.tkowalcz.tjahzi.org.agrona.Strings;
import pl.tkowalcz.tjahzi.stats.MonitoringModule;

public class BootstrapUtil {
    public static ChannelFuture initConnection(EventLoopGroup group, ClientConfiguration clientConfiguration, MonitoringModule monitoringModule) {
        Bootstrap bootstrap = new Bootstrap();
        SslContext sslContext = null;
        if (clientConfiguration.isUseSSL()) {
            sslContext = BootstrapUtil.createSslContext(clientConfiguration);
        }
        return ((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)bootstrap.group(group)).option(ChannelOption.ALLOCATOR, PooledByteBufAllocator.DEFAULT)).option(ChannelOption.SO_KEEPALIVE, true)).option(ChannelOption.TCP_NODELAY, false)).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, clientConfiguration.getConnectionTimeoutMillis())).channel(NioSocketChannel.class)).handler(new HttpClientInitializer(monitoringModule, sslContext, clientConfiguration.getHost(), clientConfiguration.getPort(), clientConfiguration.getRequestTimeoutMillis(), clientConfiguration.getMaxRequestsInFlight()))).remoteAddress(clientConfiguration.getHost(), clientConfiguration.getPort()).connect();
    }

    private static SslContext createSslContext(ClientConfiguration configuration) {
        try {
            SslContextBuilder builder = SslContextBuilder.forClient();
            TrustManagerFactory tmf = BootstrapUtil.buildTrustManagerFactory(configuration);
            builder.trustManager(tmf);
            return builder.build();
        }
        catch (SSLException e) {
            throw new RuntimeException(e);
        }
    }

    private static TrustManagerFactory buildTrustManagerFactory(ClientConfiguration configuration) {
        String trustStorePath = configuration.getTrustStorePath();
        String trustStorePassword = configuration.getTrustStorePassword();
        String trustStoreType = configuration.getTrustStoreType();
        try {
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            if (trustStorePath == null || trustStorePath.isEmpty()) {
                tmf.init((KeyStore)null);
                return tmf;
            }
            String ksType = !Strings.isEmpty(trustStoreType) ? trustStoreType : BootstrapUtil.guessKeyStoreTypeFromPath(trustStorePath);
            KeyStore keyStore = KeyStore.getInstance(ksType);
            char[] passwordChars = trustStorePassword != null ? trustStorePassword.toCharArray() : null;
            try (FileInputStream fis = new FileInputStream(trustStorePath);){
                keyStore.load(fis, passwordChars);
            }
            tmf.init(keyStore);
            return tmf;
        }
        catch (IOException | GeneralSecurityException e) {
            throw new RuntimeException("Failed to initialize TrustManagerFactory for TLS. " + e.getMessage(), e);
        }
    }

    private static String guessKeyStoreTypeFromPath(String path) {
        String lower = path.toLowerCase();
        if (lower.endsWith(".p12") || lower.endsWith(".pfx")) {
            return "PKCS12";
        }
        return KeyStore.getDefaultType();
    }
}

