/*
 * Decompiled with CFR 0.152.
 */
package pl.tkowalcz.tjahzi.log4j2;

import java.io.Serializable;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.Property;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderFactory;
import pl.tkowalcz.tjahzi.LoggingSystem;
import pl.tkowalcz.tjahzi.log4j2.AppenderLogic;
import pl.tkowalcz.tjahzi.log4j2.LokiAppenderBuilder;
import pl.tkowalcz.tjahzi.log4j2.labels.LabelPrinter;
import pl.tkowalcz.tjahzi.stats.MonitoringModule;
import pl.tkowalcz.tjahzi.stats.MutableMonitoringModuleWrapper;

@Plugin(name="Loki", category="Core", elementType="appender", printObject=true)
public class LokiAppender
extends AbstractAppender {
    private final LoggingSystem loggingSystem;
    private final MutableMonitoringModuleWrapper monitoringModuleWrapper;
    private final AppenderLogic appenderLogic;

    @PluginBuilderFactory
    public static <B extends LokiAppenderBuilder<B>> B newBuilder() {
        return (B)((Object)((LokiAppenderBuilder)new LokiAppenderBuilder().asBuilder()));
    }

    LokiAppender(String name, Layout<? extends Serializable> layout, Filter filter, boolean ignoreExceptions, Property[] properties, String logLevelLabel, Map<String, LabelPrinter> lokiLabels, Map<String, LabelPrinter> structuredMetadata, int maxLogLineSizeKilobytes, LoggingSystem loggingSystem, MutableMonitoringModuleWrapper monitoringModuleWrapper) {
        super(name, filter, layout, ignoreExceptions, properties);
        this.monitoringModuleWrapper = monitoringModuleWrapper;
        Objects.requireNonNull(layout, "layout");
        this.loggingSystem = loggingSystem;
        this.appenderLogic = new AppenderLogic(loggingSystem, logLevelLabel, lokiLabels, structuredMetadata, maxLogLineSizeKilobytes);
    }

    public LoggingSystem getLoggingSystem() {
        return this.loggingSystem;
    }

    public void setMonitoringModule(MonitoringModule monitoringModule) {
        this.monitoringModuleWrapper.setMonitoringModule(monitoringModule);
    }

    public void start() {
        this.loggingSystem.start();
        super.start();
    }

    public void append(LogEvent event) {
        this.appenderLogic.append((Layout<? extends Serializable>)this.getLayout(), event);
    }

    public boolean stop(long timeout, TimeUnit timeUnit) {
        this.setStopping();
        this.monitoringModuleWrapper.onClose();
        boolean stopped = super.stop(timeout, timeUnit, false);
        this.appenderLogic.close(timeout, timeUnit);
        this.setStopped();
        return stopped;
    }

    public String toString() {
        return "LokiAppender{name=" + this.getName() + ", state=" + this.getState() + '}';
    }
}

