/*
 * Decompiled with CFR 0.152.
 */
package pl.tkowalcz.tjahzi.protobuf;

import pl.tkowalcz.tjahzi.StructuredMetadataPointer;
import pl.tkowalcz.tjahzi.io.netty.buffer.ByteBuf;
import pl.tkowalcz.tjahzi.protobuf.LabelSerializer;
import pl.tkowalcz.tjahzi.protobuf.Protobuf;
import pl.tkowalcz.tjahzi.protobuf.StringSerializer;
import pl.tkowalcz.tjahzi.protobuf.TimestampSerializer;

public class EntrySerializer {
    public static final int TIMESTAMP_FIELD_NUMBER = 1;
    public static final int LOG_LINE_FIELD_NUMBER = 2;
    public static final int STRUCTURED_METADATA_FIELD_NUMBER = 3;

    public static void serialize(long epochMillisecond, long nanoOfMillisecond, ByteBuf logLine, StructuredMetadataPointer structuredMetadata, ByteBuf target) {
        int messageStartIndex = target.writerIndex();
        target.writeIntLE(0);
        target.writeByte(10);
        TimestampSerializer.serialize(epochMillisecond, nanoOfMillisecond, target);
        target.writeByte(18);
        StringSerializer.serialize(logLine, target);
        if (structuredMetadata.hasBytes()) {
            EntrySerializer.readStructuredMetadata(structuredMetadata, target);
        }
        Protobuf.writeSize(target, messageStartIndex);
    }

    private static void readStructuredMetadata(StructuredMetadataPointer pointer, ByteBuf target) {
        int labelsCount = pointer.readInt();
        for (int i = 0; i < labelsCount; ++i) {
            target.writeByte(26);
            String name = pointer.getStringAscii();
            String value = pointer.getStringAscii();
            LabelSerializer.serialize(name, value, target);
        }
    }
}

