/*
 * Decompiled with CFR 0.152.
 */
package pl.tkowalcz.tjahzi.log4j2.labels;

import java.util.List;
import java.util.function.Consumer;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.pattern.LiteralPatternConverter;
import org.apache.logging.log4j.core.pattern.LogEventPatternConverter;
import org.apache.logging.log4j.core.pattern.PatternFormatter;
import pl.tkowalcz.tjahzi.log4j2.labels.LabelPrinter;

public class Log4jAdapterLabelPrinter
implements LabelPrinter {
    private final StringBuilder outputBuffer = new StringBuilder();
    private final List<PatternFormatter> formatters;

    public Log4jAdapterLabelPrinter(List<PatternFormatter> formatters) {
        this.formatters = formatters;
    }

    @Override
    public void append(LogEvent event, Consumer<CharSequence> appendable) {
        this.outputBuffer.setLength(0);
        for (int i = 0; i < this.formatters.size(); ++i) {
            this.formatters.get(i).format(event, this.outputBuffer);
        }
        appendable.accept(this.outputBuffer);
    }

    @Override
    public boolean isStatic() {
        for (int i = 0; i < this.formatters.size(); ++i) {
            LogEventPatternConverter converter = this.formatters.get(i).getConverter();
            if (!(converter instanceof LiteralPatternConverter)) {
                return false;
            }
            if (!((LiteralPatternConverter)converter).getLiteral().contains("$")) continue;
            return false;
        }
        return true;
    }

    public static Log4jAdapterLabelPrinter of(List<PatternFormatter> parse) {
        return new Log4jAdapterLabelPrinter(parse);
    }
}

