/*
 * Decompiled with CFR 0.152.
 */
package pl.tkowalcz.tjahzi.log4j2;

import java.nio.ByteBuffer;
import java.util.function.BiConsumer;
import org.apache.logging.log4j.core.LogEvent;
import pl.tkowalcz.tjahzi.log4j2.TjahziByteBufferDestination;

public class ByteBufferDestinationRepository {
    public static final int DEFAULT_MAX_LINE_SIZE_BYTES = 10240;
    private final ThreadLocal<TjahziByteBufferDestination> threadLocal = new ThreadLocal();
    private final int maxLogLineSizeBytes;

    public ByteBufferDestinationRepository(int maxLogLineSizeBytes) {
        this.maxLogLineSizeBytes = maxLogLineSizeBytes;
    }

    public TjahziByteBufferDestination threadLocalDestination(BiConsumer<LogEvent, ByteBuffer> drain, LogEvent context) {
        TjahziByteBufferDestination result = this.threadLocal.get();
        if (result == null) {
            result = new TjahziByteBufferDestination(this.maxLogLineSizeBytes);
            this.threadLocal.set(result);
        }
        result.initialize(drain, context);
        return result;
    }
}

