/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.pattern;

import ch.qos.logback.classic.PatternLayout;
import ch.qos.logback.classic.pattern.EnsureExceptionHandling;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.pattern.Converter;
import ch.qos.logback.core.pattern.Encoder;
import ch.qos.logback.core.pattern.Encoders;
import ch.qos.logback.core.pattern.PatternLayoutBase;
import ch.qos.logback.core.pattern.StringBuilders;
import java.nio.ByteBuffer;
import java.util.Map;

public class EfficientPatternLayout
extends PatternLayoutBase<ILoggingEvent> {
    private static final ByteBuffer EMPTY_BUFFER = ByteBuffer.allocate(0);

    public EfficientPatternLayout() {
        this.postCompileProcessor = new EnsureExceptionHandling();
    }

    @Override
    public Map<String, String> getDefaultConverterMap() {
        return PatternLayout.defaultConverterMap;
    }

    public ByteBuffer doEfficientLayout(ILoggingEvent event) {
        if (!this.isStarted()) {
            return EMPTY_BUFFER;
        }
        return this.efficientWriteLoopOnConverters(event);
    }

    protected ByteBuffer efficientWriteLoopOnConverters(ILoggingEvent event) {
        StringBuilder strBuilder = StringBuilders.threadLocal();
        for (Converter<ILoggingEvent> c = this.head; c != null; c = c.getNext()) {
            c.write(strBuilder, event);
        }
        Encoder encoder = Encoders.threadLocal();
        encoder.encode(strBuilder);
        return encoder.getBuffer();
    }

    @Override
    protected String getPresentationHeaderPrefix() {
        return "#logback.classic pattern: ";
    }

    @Override
    public String doLayout(ILoggingEvent event) {
        ByteBuffer byteBuffer = this.doEfficientLayout(event);
        return new String(byteBuffer.array(), byteBuffer.position(), byteBuffer.limit());
    }
}

