/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.pattern;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.StandardCharsets;

public class Encoder {
    private static final int ENCODER_BUFFER_SIZE = Integer.getInteger("tjahzi.logback.layout.encoder.bufferSize", 10240);
    private final ByteBuffer buffer = ByteBuffer.allocate(ENCODER_BUFFER_SIZE);
    private final char[] temporaryTextArray = new char[1024];
    private final CharBuffer temporaryTextBuffer = CharBuffer.wrap(this.temporaryTextArray);
    private final CharsetEncoder charsetEncoder = StandardCharsets.UTF_8.newEncoder();

    public void encode(StringBuilder input) {
        int offset = 0;
        int sizeOfInput = input.length();
        while (sizeOfInput > 0) {
            int length;
            this.encodeRound(input, offset, length, (sizeOfInput -= (length = Math.min(sizeOfInput, this.temporaryTextArray.length))) == 0);
            offset += length;
        }
        this.buffer.flip();
    }

    public ByteBuffer getBuffer() {
        return this.buffer;
    }

    public void clear() {
        this.buffer.clear();
        this.charsetEncoder.reset();
    }

    private void encodeRound(StringBuilder input, int offset, int length, boolean endOfInput) {
        input.getChars(offset, offset + length, this.temporaryTextArray, 0);
        this.temporaryTextBuffer.clear().limit(length);
        CoderResult coderResult = this.charsetEncoder.encode(this.temporaryTextBuffer, this.buffer, endOfInput);
        if (coderResult.isError()) {
            throw new RuntimeException(coderResult.toString());
        }
    }
}

