/*
 * Decompiled with CFR 0.152.
 */
package pl.tkowalcz.tjahzi.logback;

import ch.qos.logback.core.spi.ContextAware;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import pl.tkowalcz.tjahzi.github.GitHubDocs;
import pl.tkowalcz.tjahzi.logback.Label;

public class LabelFactory {
    private final ContextAware internalLogger;
    private final String logLevelLabel;
    private final String loggerNameLabel;
    private final String threadNameLabel;
    private final Label[] labels;

    public LabelFactory(ContextAware internalLogger, String logLevelLabel, String loggerNameLabel, String threadNameLabel, Label ... labels) {
        this.internalLogger = internalLogger;
        this.logLevelLabel = logLevelLabel;
        this.loggerNameLabel = loggerNameLabel;
        this.threadNameLabel = threadNameLabel;
        this.labels = labels;
    }

    public HashMap<String, String> convertLabelsDroppingInvalid() {
        this.detectAndLogDuplicateLabels();
        return this.convertAndLogViolations();
    }

    public String validateLogLevelLabel(HashMap<String, String> existingLabels) {
        if (this.logLevelLabel != null) {
            return this.validatePredefinedLabelAgainst(existingLabels, this.logLevelLabel, "log level label");
        }
        return null;
    }

    public String validateLoggerNameLabel(HashMap<String, String> existingLabels) {
        if (this.loggerNameLabel != null) {
            return this.validatePredefinedLabelAgainst(existingLabels, this.loggerNameLabel, "logger name label");
        }
        return null;
    }

    public String validateThreadNameLabel(HashMap<String, String> existingLabels) {
        if (this.threadNameLabel != null) {
            return this.validatePredefinedLabelAgainst(existingLabels, this.threadNameLabel, "thread name label");
        }
        return null;
    }

    private void detectAndLogDuplicateLabels() {
        List duplicatedLabels = Arrays.stream(this.labels).collect(Collectors.groupingBy(Label::getName, Collectors.counting())).entrySet().stream().filter(entry -> (Long)entry.getValue() > 1L).map(Map.Entry::getKey).collect(Collectors.toList());
        if (!duplicatedLabels.isEmpty()) {
            this.internalLogger.addWarn(String.format("There are duplicated labels which is not allowed by Loki. These labels will be deduplicated non-deterministically: %s\n", duplicatedLabels));
        }
    }

    private HashMap<String, String> convertAndLogViolations() {
        HashMap<String, String> lokiLabels = new HashMap<String, String>();
        Arrays.stream(this.labels).flatMap(label -> {
            if (label.hasValidName()) {
                return Stream.of(label);
            }
            this.internalLogger.addWarn(String.format("Ignoring label '%s' - contains invalid characters. %s\n", label.getName(), GitHubDocs.LABEL_NAMING.getLogMessage()));
            return Stream.of(new Label[0]);
        }).forEach(__ -> lokiLabels.put(__.getName(), __.getValue()));
        return lokiLabels;
    }

    private String validatePredefinedLabelAgainst(Map<String, String> existingLabels, String predefinedLabel, String predefinedLabelDescription) {
        if (!Label.hasValidName(predefinedLabel)) {
            this.internalLogger.addWarn(String.format("Ignoring %s '%s' - contains invalid characters. %s\n", predefinedLabelDescription, predefinedLabel, GitHubDocs.LABEL_NAMING.getLogMessage()));
            return null;
        }
        if (existingLabels.remove(predefinedLabel) != null) {
            this.internalLogger.addWarn(String.format("Ignoring %s '%s' - conflicts with label defined in configuration.\n", predefinedLabelDescription, predefinedLabel));
        }
        return predefinedLabel;
    }
}

