/*
 * Decompiled with CFR 0.152.
 */
package pl.tkowalcz.tjahzi.logback;

import ch.qos.logback.classic.encoder.PatternLayoutEncoder;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.pattern.EfficientPatternLayout;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import pl.tkowalcz.tjahzi.LabelSerializer;
import pl.tkowalcz.tjahzi.LabelSerializers;
import pl.tkowalcz.tjahzi.LoggingSystem;
import pl.tkowalcz.tjahzi.TjahziLogger;
import pl.tkowalcz.tjahzi.logback.LokiAppenderConfigurator;
import pl.tkowalcz.tjahzi.logback.LokiAppenderFactory;
import pl.tkowalcz.tjahzi.stats.MonitoringModule;
import pl.tkowalcz.tjahzi.stats.MutableMonitoringModuleWrapper;

public class LokiAppender
extends LokiAppenderConfigurator {
    private EfficientPatternLayout efficientLayout;
    private PatternLayoutEncoder encoder;
    private LoggingSystem loggingSystem;
    private Function<ILoggingEvent, ByteBuffer> actualEncoder;
    private TjahziLogger logger;
    private String logLevelLabel;
    private String loggerNameLabel;
    private String threadNameLabel;
    private List<String> mdcLogLabels;
    private MutableMonitoringModuleWrapper monitoringModuleWrapper;

    public EfficientPatternLayout getEfficientLayout() {
        return this.efficientLayout;
    }

    public void setEfficientLayout(EfficientPatternLayout efficientLayout) {
        this.efficientLayout = efficientLayout;
    }

    public PatternLayoutEncoder getEncoder() {
        return this.encoder;
    }

    public void setEncoder(PatternLayoutEncoder encoder) {
        this.encoder = encoder;
    }

    public void setMonitoringModule(MonitoringModule monitoringModule) {
        this.monitoringModuleWrapper.setMonitoringModule(monitoringModule);
    }

    public LoggingSystem getLoggingSystem() {
        return this.loggingSystem;
    }

    @Override
    protected void append(ILoggingEvent event) {
        String logLevel = event.getLevel().toString();
        String loggerName = event.getLoggerName();
        String threadName = event.getThreadName();
        ByteBuffer logLine = this.actualEncoder.apply(event);
        Map<String, String> mdcPropertyMap = event.getMDCPropertyMap();
        LabelSerializer labelSerializer = LabelSerializers.threadLocal();
        this.appendLogLabel(labelSerializer, logLevel);
        this.appendLoggerLabel(labelSerializer, loggerName);
        this.appendThreadLabel(labelSerializer, threadName);
        this.appendMdcLogLabels(labelSerializer, mdcPropertyMap);
        this.logger.log(event.getTimeStamp(), 0L, labelSerializer, logLine);
    }

    private void appendLogLabel(LabelSerializer labelSerializer, String logLevel) {
        if (this.logLevelLabel != null) {
            labelSerializer.appendLabel(this.logLevelLabel, logLevel);
        }
    }

    private void appendLoggerLabel(LabelSerializer labelSerializer, String loggerName) {
        if (this.loggerNameLabel != null) {
            labelSerializer.appendLabel(this.loggerNameLabel, loggerName);
        }
    }

    private void appendThreadLabel(LabelSerializer labelSerializer, String threadName) {
        if (this.threadNameLabel != null) {
            labelSerializer.appendLabel(this.threadNameLabel, threadName);
        }
    }

    private void appendMdcLogLabels(LabelSerializer serializer, Map<String, String> mdcPropertyMap) {
        for (int i = 0; i < this.mdcLogLabels.size(); ++i) {
            String mdcLogLabel = this.mdcLogLabels.get(i);
            if (!mdcPropertyMap.containsKey(mdcLogLabel)) continue;
            serializer.appendLabel(mdcLogLabel, mdcPropertyMap.get(mdcLogLabel));
        }
    }

    @Override
    public void start() {
        if (this.encoder == null) {
            if (this.efficientLayout == null) {
                this.addError("No encoder set for the appender named [" + this.name + "]. You can also try setting efficientLayout instead.");
                return;
            }
            this.actualEncoder = this.efficientLayout::doEfficientLayout;
        } else {
            this.encoder.start();
            this.actualEncoder = event -> ByteBuffer.wrap(this.encoder.encode(event));
        }
        LokiAppenderFactory lokiAppenderFactory = new LokiAppenderFactory(this);
        this.loggingSystem = lokiAppenderFactory.createAppender();
        this.logLevelLabel = lokiAppenderFactory.getLogLevelLabel();
        this.loggerNameLabel = lokiAppenderFactory.getLoggerNameLabel();
        this.threadNameLabel = lokiAppenderFactory.getThreadNameLabel();
        this.mdcLogLabels = lokiAppenderFactory.getMdcLogLabels();
        this.monitoringModuleWrapper = lokiAppenderFactory.getMonitoringModuleWrapper();
        this.logger = this.loggingSystem.createLogger();
        this.loggingSystem.start();
        super.start();
    }

    @Override
    public void stop() {
        this.loggingSystem.close((int)TimeUnit.SECONDS.toMillis(this.getShutdownTimeoutSeconds()), thread -> this.addError("Loki appender was unable to stop thread on shutdown: " + thread));
        super.stop();
    }
}

