/*
 * Decompiled with CFR 0.152.
 */
package pl.tkowalcz.tjahzi.logback;

import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import pl.tkowalcz.tjahzi.LoggingSystem;
import pl.tkowalcz.tjahzi.TjahziInitializer;
import pl.tkowalcz.tjahzi.github.GitHubDocs;
import pl.tkowalcz.tjahzi.http.ClientConfiguration;
import pl.tkowalcz.tjahzi.http.HttpClientFactory;
import pl.tkowalcz.tjahzi.http.NettyHttpClient;
import pl.tkowalcz.tjahzi.logback.Label;
import pl.tkowalcz.tjahzi.logback.LabelFactory;
import pl.tkowalcz.tjahzi.logback.LokiAppenderConfigurator;
import pl.tkowalcz.tjahzi.stats.MutableMonitoringModuleWrapper;
import pl.tkowalcz.tjahzi.stats.StandardMonitoringModule;

public class LokiAppenderFactory {
    private final LokiAppenderConfigurator configurator;
    private final HashMap<String, String> lokiLabels;
    private final String logLevelLabel;
    private final String loggerNameLabel;
    private final String threadNameLabel;
    private final List<String> mdcLogLabels;
    private final MutableMonitoringModuleWrapper monitoringModuleWrapper;

    public LokiAppenderFactory(LokiAppenderConfigurator configurator) {
        this.configurator = configurator;
        LabelFactory labelFactory = new LabelFactory(configurator, configurator.getLogLevelLabel(), configurator.getLoggerNameLabel(), configurator.getThreadNameLabel(), configurator.getLabels().toArray(new Label[0]));
        this.lokiLabels = labelFactory.convertLabelsDroppingInvalid();
        this.logLevelLabel = labelFactory.validateLogLevelLabel(this.lokiLabels);
        this.loggerNameLabel = labelFactory.validateLoggerNameLabel(this.lokiLabels);
        this.threadNameLabel = labelFactory.validateThreadNameLabel(this.lokiLabels);
        this.mdcLogLabels = configurator.getMdcLogLabels();
        this.monitoringModuleWrapper = new MutableMonitoringModuleWrapper();
    }

    public LoggingSystem createAppender() {
        ClientConfiguration configurationBuilder = ClientConfiguration.builder().withUrl(this.configurator.getUrl()).withLogEndpoint(this.configurator.getLogEndpoint()).withHost(this.configurator.getHost()).withPort(this.configurator.getPort()).withUseSSL(this.configurator.isUseSSL()).withUsername(this.configurator.getUsername()).withPassword(this.configurator.getPassword()).withConnectionTimeoutMillis(this.configurator.getConnectTimeoutMillis()).withMaxRetries(this.configurator.getMaxRetries()).withRequestTimeoutMillis(this.configurator.getReadTimeoutMillis()).withMaxRequestsInFlight(this.configurator.getMaxRequestsInFlight()).build();
        String[] additionalHeaders = (String[])this.configurator.getHeaders().stream().flatMap(header -> Stream.of(header.getName(), header.getValue())).toArray(String[]::new);
        this.monitoringModuleWrapper.setMonitoringModule(new StandardMonitoringModule());
        NettyHttpClient httpClient = HttpClientFactory.defaultFactory().getHttpClient(configurationBuilder, this.monitoringModuleWrapper, additionalHeaders);
        int bufferSizeBytes = this.configurator.getBufferSizeMegabytes() * 0x100000;
        if (!TjahziInitializer.isCorrectSize(bufferSizeBytes)) {
            this.configurator.addWarn(String.format("Invalid log buffer size %d - using nearest power of two greater than provided value, no less than 1MB. %s\n", bufferSizeBytes, GitHubDocs.LOG_BUFFER_SIZING.getLogMessage()));
        }
        return new TjahziInitializer().createLoggingSystem(httpClient, this.monitoringModuleWrapper, this.lokiLabels, this.configurator.getBatchSize(), TimeUnit.SECONDS.toMillis(this.configurator.getBatchWait()), bufferSizeBytes, this.configurator.getLogShipperWakeupIntervalMillis(), TimeUnit.SECONDS.toMillis(this.configurator.getShutdownTimeoutSeconds()), this.configurator.isUseOffHeapBuffer(), this.configurator.isUseDaemonThreads());
    }

    public String getLogLevelLabel() {
        return this.logLevelLabel;
    }

    public String getLoggerNameLabel() {
        return this.loggerNameLabel;
    }

    public String getThreadNameLabel() {
        return this.threadNameLabel;
    }

    public MutableMonitoringModuleWrapper getMonitoringModuleWrapper() {
        return this.monitoringModuleWrapper;
    }

    public List<String> getMdcLogLabels() {
        return this.mdcLogLabels;
    }
}

