/*
 * Decompiled with CFR 0.152.
 */
package pl.tlinkowski.unij.api;

import java.util.ArrayList;
import java.util.Collection;
import java.util.ServiceLoader;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import kotlin.annotations.jvm.ReadOnly;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.tlinkowski.unij.api.UniJException;
import pl.tlinkowski.unij.service.api.UniJService;

final class UniJLoader {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(UniJLoader.class);

    static <S> S load(Class<S> serviceClass) {
        ArrayList services = new ArrayList(4);
        ServiceLoader.load(serviceClass).forEach(services::add);
        UniJLoader.validateLoadedServices(services, serviceClass);
        return (S)UniJLoader.selectService(services, serviceClass);
    }

    private static <S> void validateLoadedServices(@ReadOnly Collection<S> services, Class<S> serviceClass) {
        if (services.isEmpty()) {
            throw new UniJException(String.format("%s service implementation not found. Ensure proper pl.tlinkowski.unij.service.* dependency is on the runtime classpath/modulepath", serviceClass.getName()));
        }
        log.debug("{} service: found {}", (Object)serviceClass.getName(), services);
    }

    private static <S> S selectService(@ReadOnly Collection<S> services, Class<S> serviceClass) {
        return UniJLoader.selectService(UniJLoader.buildPriorityServiceMap(services), serviceClass);
    }

    private static <S> S selectService(@ReadOnly SortedMap<Integer, S> priorityServiceMap, Class<S> serviceClass) {
        Integer highestPriority = priorityServiceMap.firstKey();
        Object highestPriorityService = priorityServiceMap.get(highestPriority);
        log.info("{} service: selected {} (priority={})", new Object[]{serviceClass.getName(), UniJLoader.className(highestPriorityService), highestPriority});
        return (S)highestPriorityService;
    }

    @ReadOnly
    private static <S> SortedMap<Integer, S> buildPriorityServiceMap(@ReadOnly Collection<? extends S> services) {
        return services.stream().collect(Collectors.toMap(UniJLoader::detectPriority, Function.identity(), UniJLoader::throwOnDuplicatePriority, TreeMap::new));
    }

    private static int detectPriority(Object service) {
        UniJService uniJServiceAnn = service.getClass().getAnnotation(UniJService.class);
        if (uniJServiceAnn == null) {
            throw new UniJException(String.format("Service implementation %s not annotated with @%s", UniJLoader.className(service), UniJService.class.getSimpleName()));
        }
        return uniJServiceAnn.priority();
    }

    private static <S> S throwOnDuplicatePriority(S service1, S service2) {
        throw new UniJException(String.format("%s and %s have the same priority", UniJLoader.className(service1), UniJLoader.className(service2)));
    }

    private static String className(Object object) {
        return object.getClass().getName();
    }

    @Generated
    private UniJLoader() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

