/*
 * Decompiled with CFR 0.152.
 */
package pl.touk.nussknacker.ui.process;

import cats.Applicative;
import cats.Functor;
import cats.Monad;
import cats.data.EitherT;
import cats.data.EitherT$;
import cats.instances.package;
import cats.syntax.EitherIdOps$;
import cats.syntax.package;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import pl.touk.nussknacker.engine.api.deployment.ProcessActionType$;
import pl.touk.nussknacker.engine.api.deployment.ProcessState;
import pl.touk.nussknacker.engine.api.expression.ExpressionTypingInfo;
import pl.touk.nussknacker.engine.api.process.ProcessName;
import pl.touk.nussknacker.engine.api.process.VersionId;
import pl.touk.nussknacker.engine.canonicalgraph.CanonicalProcess;
import pl.touk.nussknacker.engine.marshall.ProcessMarshaller$;
import pl.touk.nussknacker.restmodel.displayedgraph.DisplayableProcess;
import pl.touk.nussknacker.restmodel.displayedgraph.ValidatedDisplayableProcess;
import pl.touk.nussknacker.restmodel.process.ProcessIdWithName;
import pl.touk.nussknacker.restmodel.process.package;
import pl.touk.nussknacker.restmodel.processdetails;
import pl.touk.nussknacker.restmodel.validation.ValidationResults;
import pl.touk.nussknacker.ui.EspError;
import pl.touk.nussknacker.ui.api.ProcessesResources$UnmarshallError$;
import pl.touk.nussknacker.ui.listener.Comment;
import pl.touk.nussknacker.ui.process.NewProcessPreparer;
import pl.touk.nussknacker.ui.process.ProcessCategoryService;
import pl.touk.nussknacker.ui.process.ProcessService;
import pl.touk.nussknacker.ui.process.deployment.DeploymentService;
import pl.touk.nussknacker.ui.process.exception.ProcessIllegalAction;
import pl.touk.nussknacker.ui.process.exception.ProcessIllegalAction$;
import pl.touk.nussknacker.ui.process.exception.ProcessValidationError;
import pl.touk.nussknacker.ui.process.marshall.ProcessConverter$;
import pl.touk.nussknacker.ui.process.repository.DBIOActionRunner;
import pl.touk.nussknacker.ui.process.repository.FetchingProcessRepository;
import pl.touk.nussknacker.ui.process.repository.FetchingProcessRepository$FetchProcessesDetailsQuery$;
import pl.touk.nussknacker.ui.process.repository.ProcessActionRepository;
import pl.touk.nussknacker.ui.process.repository.ProcessDBQueryRepository;
import pl.touk.nussknacker.ui.process.repository.ProcessRepository;
import pl.touk.nussknacker.ui.process.subprocess.SubprocessDetails;
import pl.touk.nussknacker.ui.security.api.LoggedUser;
import pl.touk.nussknacker.ui.uiresolving.UIProcessResolving;
import pl.touk.nussknacker.ui.validation.FatalValidationError$;
import pl.touk.nussknacker.ui.validation.ProcessValidation;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import slick.dbio.DBIOAction;
import slick.dbio.DBIOAction$;

@ScalaSignature(bytes="\u0006\u0001\u0011]g\u0001B\u0012%\u0001=B\u0001\u0002\u0012\u0001\u0003\u0002\u0003\u0006I!\u0012\u0005\t\u0017\u0002\u0011\t\u0011)A\u0005\u0019\"Aq\n\u0001B\u0001B\u0003%\u0001\u000b\u0003\u0005T\u0001\t\u0005\t\u0015!\u0003U\u0011!Q\u0006A!A!\u0002\u0013Y\u0006\u0002C1\u0001\u0005\u0003\u0005\u000b\u0011\u00022\t\u0011-\u0004!\u0011!Q\u0001\n1D!\"a\u0001\u0001\u0005\u0003\u0005\u000b\u0011BA\u0003\u0011)\tY\u0001\u0001B\u0001B\u0003%\u0011Q\u0002\u0005\u000b\u00033\u0001!\u0011!Q\u0001\f\u0005m\u0001bBA\u0011\u0001\u0011\u0005\u00111\u0005\u0005\b\u0003{\u0001A\u0011IA \u0011\u001d\ti\t\u0001C!\u0003\u001fCq!a&\u0001\t\u0003\nI\nC\u0004\u0002\"\u0002!\t%a)\t\u000f\u0005\u0015\b\u0001\"\u0011\u0002h\"9!Q\u0002\u0001\u0005B\t=\u0001b\u0002B\u0015\u0001\u0011\u0005#1\u0006\u0005\b\u0005\u000f\u0002A\u0011\tB%\u0011\u001d\u0011)\t\u0001C!\u0005\u000fCqA!,\u0001\t\u0003\u0012y\u000bC\u0004\u0003H\u0002!\tE!3\t\u000f\tU\b\u0001\"\u0001\u0003x\"91Q\u0003\u0001\u0005\n\r]\u0001bBB#\u0001\u0011%1q\t\u0005\b\u00073\u0002A\u0011BB.\u0011\u001d\u0019\u0019\u000b\u0001C\u0005\u0007KCqaa.\u0001\t\u0013\u0019I\fC\u0004\u0004V\u0002!Iaa6\t\u000f\u0011\u0015\u0001\u0001\"\u0003\u0005\b!9AQ\u0001\u0001\u0005\n\u0011]\u0002b\u0002C3\u0001\u0011%Aq\r\u0005\b\t'\u0003A\u0011\u0002CK\u0011\u001d\u0011)\t\u0001C\u0005\tk\u0013\u0001\u0003\u0012\"Qe>\u001cWm]:TKJ4\u0018nY3\u000b\u0005\u00152\u0013a\u00029s_\u000e,7o\u001d\u0006\u0003O!\n!!^5\u000b\u0005%R\u0013a\u00038vgN\\g.Y2lKJT!a\u000b\u0017\u0002\tQ|Wo\u001b\u0006\u0002[\u0005\u0011\u0001\u000f\\\u0002\u0001'\u0011\u0001\u0001G\u000e\u001e\u0011\u0005E\"T\"\u0001\u001a\u000b\u0003M\nQa]2bY\u0006L!!\u000e\u001a\u0003\r\u0005s\u0017PU3g!\t9\u0004(D\u0001%\u0013\tIDE\u0001\bQe>\u001cWm]:TKJ4\u0018nY3\u0011\u0005m\u0012U\"\u0001\u001f\u000b\u0005ur\u0014\u0001D:dC2\fGn\\4hS:<'BA A\u0003!!\u0018\u0010]3tC\u001a,'\"A!\u0002\u0007\r|W.\u0003\u0002Dy\tYA*\u0019>z\u0019><w-\u001b8h\u0003E!W\r\u001d7ps6,g\u000e^*feZL7-\u001a\t\u0003\r&k\u0011a\u0012\u0006\u0003\u0011\u0012\n!\u0002Z3qY>LX.\u001a8u\u0013\tQuIA\tEKBdw._7f]R\u001cVM\u001d<jG\u0016\f!C\\3x!J|7-Z:t!J,\u0007/\u0019:feB\u0011q'T\u0005\u0003\u001d\u0012\u0012!CT3x!J|7-Z:t!J,\u0007/\u0019:fe\u00061\u0002O]8dKN\u001c8)\u0019;fO>\u0014\u0018pU3sm&\u001cW\r\u0005\u00028#&\u0011!\u000b\n\u0002\u0017!J|7-Z:t\u0007\u0006$XmZ8ssN+'O^5dK\u0006\u0001\u0002O]8dKN\u001c(+Z:pYZLgn\u001a\t\u0003+bk\u0011A\u0016\u0006\u0003/\u001a\n1\"^5sKN|GN^5oO&\u0011\u0011L\u0016\u0002\u0013+&\u0003&o\\2fgN\u0014Vm]8mm&tw-\u0001\u0006eE&|'+\u001e8oKJ\u0004\"\u0001X0\u000e\u0003uS!A\u0018\u0013\u0002\u0015I,\u0007o\\:ji>\u0014\u00180\u0003\u0002a;\n\u0001BIQ%P\u0003\u000e$\u0018n\u001c8Sk:tWM]\u0001\u001aM\u0016$8\r[5oOB\u0013xnY3tgJ+\u0007o\\:ji>\u0014\u0018\u0010E\u0002]G\u0016L!\u0001Z/\u00033\u0019+Go\u00195j]\u001e\u0004&o\\2fgN\u0014V\r]8tSR|'/\u001f\t\u0003M&l\u0011a\u001a\u0006\u0003QJ\n!bY8oGV\u0014(/\u001a8u\u0013\tQwM\u0001\u0004GkR,(/Z\u0001\u0018aJ|7-Z:t\u0003\u000e$\u0018n\u001c8SKB|7/\u001b;pef\u00042\u0001X7p\u0013\tqWLA\fQe>\u001cWm]:BGRLwN\u001c*fa>\u001c\u0018\u000e^8ssB\u0011\u0001O \b\u0003cnt!A\u001d=\u000f\u0005M4X\"\u0001;\u000b\u0005Ut\u0013A\u0002\u001fs_>$h(C\u0001x\u0003\t!'-\u0003\u0002zu\u0006!Q\u000f^5m\u0015\u00059\u0018B\u0001?~\u0003M!%)S(BGRLwN\\%ogR\fgnY3t\u0015\tI(0C\u0002\u0000\u0003\u0003\u0011!\u0001\u0012\"\u000b\u0005ql\u0018!\u00059s_\u000e,7o\u001d*fa>\u001c\u0018\u000e^8ssB!A,a\u0002p\u0013\r\tI!\u0018\u0002\u0012!J|7-Z:t%\u0016\u0004xn]5u_JL\u0018!\u00059s_\u000e,7o\u001d,bY&$\u0017\r^5p]B!\u0011qBA\u000b\u001b\t\t\tBC\u0002\u0002\u0014\u0019\n!B^1mS\u0012\fG/[8o\u0013\u0011\t9\"!\u0005\u0003#A\u0013xnY3tgZ\u000bG.\u001b3bi&|g.\u0001\u0002fGB\u0019a-!\b\n\u0007\u0005}qM\u0001\tFq\u0016\u001cW\u000f^5p]\u000e{g\u000e^3yi\u00061A(\u001b8jiz\"B#!\n\u0002,\u00055\u0012qFA\u0019\u0003g\t)$a\u000e\u0002:\u0005mB\u0003BA\u0014\u0003S\u0001\"a\u000e\u0001\t\u000f\u0005e1\u0002q\u0001\u0002\u001c!)Ai\u0003a\u0001\u000b\")1j\u0003a\u0001\u0019\")qj\u0003a\u0001!\")1k\u0003a\u0001)\")!l\u0003a\u00017\")\u0011m\u0003a\u0001E\")1n\u0003a\u0001Y\"9\u00111A\u0006A\u0002\u0005\u0015\u0001bBA\u0006\u0017\u0001\u0007\u0011QB\u0001\u000fCJ\u001c\u0007.\u001b<f!J|7-Z:t)\u0011\t\t%a\u001f\u0015\t\u0005\r\u0013q\r\t\u0005M&\f)\u0005\u0005\u0003\u0002H\u0005\u0005d\u0002BA%\u0003;rA!a\u0013\u0002\\9!\u0011QJA-\u001d\u0011\ty%a\u0016\u000f\t\u0005E\u0013Q\u000b\b\u0004g\u0006M\u0013\"A\u0017\n\u0005-b\u0013BA\u0015+\u0013\t9\u0003&\u0003\u0002&M%\u0019\u0011q\f\u0013\u0002\u001dA\u0013xnY3tgN+'O^5dK&!\u00111MA3\u00055)U\u000e\u001d;z%\u0016\u001c\bo\u001c8tK*\u0019\u0011q\f\u0013\t\u000f\u0005%D\u0002q\u0001\u0002l\u0005!Qo]3s!\u0011\ti'a\u001e\u000e\u0005\u0005=$\u0002BA9\u0003g\n1!\u00199j\u0015\r\t)HJ\u0001\tg\u0016\u001cWO]5us&!\u0011\u0011PA8\u0005)aunZ4fIV\u001bXM\u001d\u0005\b\u0003{b\u0001\u0019AA@\u0003E\u0001(o\\2fgNLEmV5uQ:\u000bW.\u001a\t\u0005\u0003\u0003\u000bI)\u0004\u0002\u0002\u0004*\u0019Q%!\"\u000b\u0007\u0005\u001d\u0005&A\u0005sKN$Xn\u001c3fY&!\u00111RAB\u0005E\u0001&o\\2fgNLEmV5uQ:\u000bW.Z\u0001\u0011k:\f%o\u00195jm\u0016\u0004&o\\2fgN$B!!%\u0002\u0016R!\u00111IAJ\u0011\u001d\tI'\u0004a\u0002\u0003WBq!! \u000e\u0001\u0004\ty(A\u0007eK2,G/\u001a)s_\u000e,7o\u001d\u000b\u0005\u00037\u000by\n\u0006\u0003\u0002D\u0005u\u0005bBA5\u001d\u0001\u000f\u00111\u000e\u0005\b\u0003{r\u0001\u0019AA@\u00035\u0011XM\\1nKB\u0013xnY3tgR1\u0011QUAh\u0003#$B!a*\u0002NB!a-[AU!\u0019\tY+!-\u00028:!\u00111JAW\u0013\r\tyKJ\u0001\t\u000bN\u0004XI\u001d:pe&!\u00111WA[\u0005\u0019AVI\u001d:pe*\u0019\u0011q\u0016\u0014\u0011\t\u0005e\u0016q\u0019\b\u0005\u0003w\u000b\u0019M\u0004\u0003\u0002>\u0006\u0005g\u0002BA'\u0003\u007fK1!a\")\u0013\r)\u0013QQ\u0005\u0005\u0003\u000b\f\u0019)A\u0004qC\u000e\\\u0017mZ3\n\t\u0005%\u00171\u001a\u0002\u001a+B$\u0017\r^3Qe>\u001cWm]:OC6,'+Z:q_:\u001cXM\u0003\u0003\u0002F\u0006\r\u0005bBA5\u001f\u0001\u000f\u00111\u000e\u0005\b\u0003{z\u0001\u0019AA@\u0011\u001d\t\u0019n\u0004a\u0001\u0003+\fAA\\1nKB!\u0011q[Aq\u001b\t\tINC\u0002&\u00037TA!!\u001d\u0002^*\u0019\u0011q\u001c\u0015\u0002\r\u0015tw-\u001b8f\u0013\u0011\t\u0019/!7\u0003\u0017A\u0013xnY3tg:\u000bW.Z\u0001\u000fkB$\u0017\r^3DCR,wm\u001c:z)\u0019\tI/a>\u0002zR!\u00111^A{!\u00111\u0017.!<\u0011\r\u0005-\u0016\u0011WAx!\u0011\tI,!=\n\t\u0005M\u00181\u001a\u0002\u001e+B$\u0017\r^3Qe>\u001cWm]:DCR,wm\u001c:z%\u0016\u001c\bo\u001c8tK\"9\u0011\u0011\u000e\tA\u0004\u0005-\u0004bBA?!\u0001\u0007\u0011q\u0010\u0005\b\u0003w\u0004\u0002\u0019AA\u007f\u0003!\u0019\u0017\r^3h_JL\b\u0003BA\u0000\u0005\u000fqAA!\u0001\u0003\u0004A\u00111OM\u0005\u0004\u0005\u000b\u0011\u0014A\u0002)sK\u0012,g-\u0003\u0003\u0003\n\t-!AB*ue&twMC\u0002\u0003\u0006I\nQb\u0019:fCR,\u0007K]8dKN\u001cH\u0003\u0002B\t\u0005?!BAa\u0005\u0003\u001eA!a-\u001bB\u000b!\u0019\tY+!-\u0003\u0018A!\u0011\u0011\u0018B\r\u0013\u0011\u0011Y\"a3\u0003\u001fA\u0013xnY3tgJ+7\u000f]8og\u0016Dq!!\u001b\u0012\u0001\b\tY\u0007C\u0004\u0003\"E\u0001\rAa\t\u0002\u000f\r|W.\\1oIB!\u0011q\tB\u0013\u0013\u0011\u00119#!\u001a\u0003)\r\u0013X-\u0019;f!J|7-Z:t\u0007>lW.\u00198e\u00035)\b\u000fZ1uKB\u0013xnY3tgR1!Q\u0006B\u001e\u0005{!BAa\f\u0003:A!a-\u001bB\u0019!\u0019\tY+!-\u00034A!\u0011\u0011\u0018B\u001b\u0013\u0011\u00119$a3\u0003+U\u0003H-\u0019;f!J|7-Z:t%\u0016\u001c\bo\u001c8tK\"9\u0011\u0011\u000e\nA\u0004\u0005-\u0004bBA?%\u0001\u0007\u0011q\u0010\u0005\b\u0005\u007f\u0011\u0002\u0019\u0001B!\u0003\u0019\t7\r^5p]B!\u0011q\tB\"\u0013\u0011\u0011)%!\u001a\u0003)U\u0003H-\u0019;f!J|7-Z:t\u0007>lW.\u00198e\u0003)9W\r\u001e)s_\u000e,7o]\u000b\u0005\u0005\u0017\u0012)\u0007\u0006\u0003\u0003N\t\rEC\u0002B(\u0005o\u0012\t\t\u0005\u0003gS\nE\u0003CBAV\u0003c\u0013\u0019\u0006\u0005\u0004\u0003V\tm#\u0011\r\b\u0005\u0003{\u00139&\u0003\u0003\u0003Z\u0005\u0015\u0015A\u00049s_\u000e,7o\u001d3fi\u0006LGn]\u0005\u0005\u0005;\u0012yF\u0001\nCCN,\u0007K]8dKN\u001cH)\u001a;bS2\u001c(\u0002\u0002B-\u0003\u000b\u0003BAa\u0019\u0003f1\u0001Aa\u0002B4'\t\u0007!\u0011\u000e\u0002\u0003!N\u000bBAa\u001b\u0003rA\u0019\u0011G!\u001c\n\u0007\t=$GA\u0004O_RD\u0017N\\4\u0011\u0007E\u0012\u0019(C\u0002\u0003vI\u00121!\u00118z\u0011%\u0011IhEA\u0001\u0002\b\u0011Y(\u0001\u0006fm&$WM\\2fIQ\u0002bA!\u0016\u0003~\t\u0005\u0014\u0002\u0002B@\u0005?\u0012\u0011\u0004\u0015:pG\u0016\u001c8o\u00155ba\u00164U\r^2i'R\u0014\u0018\r^3hs\"9\u0011\u0011N\nA\u0004\u0005-\u0004bBA?'\u0001\u0007\u0011qP\u0001\rO\u0016$\bK]8dKN\u001cXm]\u000b\u0005\u0005\u0013\u0013\u0019\u000b\u0006\u0003\u0003\f\n-F\u0003\u0002BG\u0005K\u0003BAZ5\u0003\u0010B1!\u0011\u0013BM\u0005?sAAa%\u0003\u0018:\u00191O!&\n\u0003MJ1!!23\u0013\u0011\u0011YJ!(\u0003\t1K7\u000f\u001e\u0006\u0004\u0003\u000b\u0014\u0004C\u0002B+\u00057\u0012\t\u000b\u0005\u0003\u0003d\t\rFa\u0002B4)\t\u0007!\u0011\u000e\u0005\n\u0005O#\u0012\u0011!a\u0002\u0005S\u000b!\"\u001a<jI\u0016t7-\u001a\u00136!\u0019\u0011)F! \u0003\"\"9\u0011\u0011\u000e\u000bA\u0002\u0005-\u0014\u0001F4fi\u0006\u00138\r[5wK\u0012\u0004&o\\2fgN,7/\u0006\u0003\u00032\nuF\u0003\u0002BZ\u0005\u000b$BA!.\u0003@B!a-\u001bB\\!\u0019\u0011\tJ!'\u0003:B1!Q\u000bB.\u0005w\u0003BAa\u0019\u0003>\u00129!qM\u000bC\u0002\t%\u0004\"\u0003Ba+\u0005\u0005\t9\u0001Bb\u0003))g/\u001b3f]\u000e,GE\u000e\t\u0007\u0005+\u0012iHa/\t\u000f\u0005%T\u00031\u0001\u0002l\u0005yq-\u001a;Tk\n\u0004&o\\2fgN,7\u000f\u0006\u0003\u0003L\n\rH\u0003\u0002Bg\u0005C\u0004BAZ5\u0003PB1\u0011q Bi\u0005+LAAa5\u0003\f\t\u00191+\u001a;\u0011\t\t]'Q\\\u0007\u0003\u00053T1Aa7%\u0003)\u0019XO\u00199s_\u000e,7o]\u0005\u0005\u0005?\u0014INA\tTk\n\u0004(o\\2fgN$U\r^1jYNDq!!\u001b\u0017\u0001\b\tY\u0007C\u0004\u0003fZ\u0001\rAa:\u0002\u001fA\u0014xnY3tg&tw\rV=qKN\u0004R!\rBu\u0005[L1Aa;3\u0005\u0019y\u0005\u000f^5p]B1!\u0011\u0013BM\u0005_\u0004B!!/\u0003r&!!1_Af\u00059\u0001&o\\2fgNLgn\u001a+za\u0016\fQ\"[7q_J$\bK]8dKN\u001cHC\u0002B}\u0007\u001b\u0019\t\u0002\u0006\u0003\u0003|\u000e-\u0001\u0003\u00024j\u0005{\u0004b!a+\u00022\n}\b\u0003BB\u0001\u0007\u000fi!aa\u0001\u000b\t\r\u0015\u0011QQ\u0001\u000fI&\u001c\b\u000f\\1zK\u0012<'/\u00199i\u0013\u0011\u0019Iaa\u0001\u00037Y\u000bG.\u001b3bi\u0016$G)[:qY\u0006L\u0018M\u00197f!J|7-Z:t\u0011\u001d\tIg\u0006a\u0002\u0003WBqaa\u0004\u0018\u0001\u0004\ty(A\u0005qe>\u001cWm]:JI\"911C\fA\u0002\u0005u\u0018A\u00036t_:\u001cFO]5oO\u0006\tc/\u00197jI\u0006$X-\u00138ji&\fGnU2f]\u0006\u0014\u0018n\u001c)s_B,'\u000f^5fgRA1\u0011DB\u0018\u0007\u007f\u0019\u0019\u0005\u0005\u0004\u0003\u0012\ne51\u0004\t\u0005\u0007;\u0019IC\u0004\u0003\u0004 \r\rb\u0002BA_\u0007CIA!a\u0005\u0002\u0006&!1QEB\u0014\u0003E1\u0016\r\\5eCRLwN\u001c*fgVdGo\u001d\u0006\u0005\u0003'\t))\u0003\u0003\u0004,\r5\"a\u0005(pI\u00164\u0016\r\\5eCRLwN\\#se>\u0014(\u0002BB\u0013\u0007OAqa!\r\u0019\u0001\u0004\u0019\u0019$\u0001\tdC:|g.[2bYB\u0013xnY3tgB!1QGB\u001e\u001b\t\u00199D\u0003\u0003\u0004:\u0005u\u0017AD2b]>t\u0017nY1mOJ\f\u0007\u000f[\u0005\u0005\u0007{\u00199D\u0001\tDC:|g.[2bYB\u0013xnY3tg\"91\u0011\t\rA\u0002\t=\u0018A\u00049s_\u000e,7o]5oORK\b/\u001a\u0005\b\u0003wD\u0002\u0019AA\u007f\u0003E\t'o\u00195jm\u0016\u001cVO\u00199s_\u000e,7o\u001d\u000b\u0005\u0007\u0013\u001ai\u0005\u0006\u0003\u0002D\r-\u0003bBA53\u0001\u000f\u00111\u000e\u0005\u0007Ke\u0001\raa\u00141\t\rE3Q\u000b\t\u0007\u0005+\u0012Yfa\u0015\u0011\t\t\r4Q\u000b\u0003\r\u0007/\u001ai%!A\u0001\u0002\u000b\u0005!\u0011\u000e\u0002\u0004?\u0012\n\u0014\u0001\b3p\u001f:\u0004&o\\2fgN\u001cF/\u0019;f-\u0016\u0014\u0018NZ5dCRLwN\u001c\u000b\u0007\u0007;\u001a9ha!\u0015\t\r}31\r\u000b\u0005\u0003\u0007\u001a\t\u0007C\u0004\u0002ji\u0001\u001d!a\u001b\t\u000f\r\u0015$\u00041\u0001\u0004h\u0005A1-\u00197mE\u0006\u001c7\u000eE\u00042\u0007S\u001ai'a\u0011\n\u0007\r-$GA\u0005Gk:\u001cG/[8ocA\"1qNB:!\u0019\u0011)Fa\u0017\u0004rA!!1MB:\t1\u0019)ha\u0019\u0002\u0002\u0003\u0005)\u0011\u0001B5\u0005\ryFe\r\u0005\u0007Ki\u0001\ra!\u001f1\t\rm4q\u0010\t\u0007\u0005+\u0012Yf! \u0011\t\t\r4q\u0010\u0003\r\u0007\u0003\u001b9(!A\u0001\u0002\u000b\u0005!\u0011\u000e\u0002\u0004?\u0012\u0012\u0004bBBC5\u0001\u00071qQ\u0001\u000eC\u000e$\u0018n\u001c8U_\u000eCWmY6\u0011\t\r%5Q\u0014\b\u0005\u0007\u0017\u001b9J\u0004\u0003\u0004\u000e\u000eUe\u0002BBH\u0007'sA!!\u0014\u0004\u0012&\u0019\u0011q\u001c\u0015\n\t\u0005E\u0014Q\\\u0005\u0004\u0011\u0006m\u0017\u0002BBM\u00077\u000b\u0011\u0003\u0015:pG\u0016\u001c8/Q2uS>tG+\u001f9f\u0015\rA\u00151\\\u0005\u0005\u0007?\u001b\tKA\tQe>\u001cWm]:BGRLwN\u001c+za\u0016TAa!'\u0004\u001c\u0006IAm\\!sG\"Lg/\u001a\u000b\u0005\u0007O\u001bY\u000b\u0006\u0003\u0002D\r%\u0006bBA57\u0001\u000f\u00111\u000e\u0005\u0007Km\u0001\ra!,1\t\r=61\u0017\t\u0007\u0005+\u0012Yf!-\u0011\t\t\r41\u0017\u0003\r\u0007k\u001bY+!A\u0001\u0002\u000b\u0005!\u0011\u000e\u0002\u0004?\u0012\"\u0014!\u0005;p!J|7-Z:t%\u0016\u001c\bo\u001c8tKR1!qCB^\u0007\u007fCqa!0\u001d\u0001\u0004\t).A\u0006qe>\u001cWm]:OC6,\u0007bBBa9\u0001\u000711Y\u0001\bGJ,\u0017\r^3e!\u0011\u0019)ma4\u000f\t\r\u001d71\u001a\b\u0005\u0003\u0013\u001aI-\u0003\u0002_I%\u00191QZ/\u0002#A\u0013xnY3tgJ+\u0007o\\:ji>\u0014\u00180\u0003\u0003\u0004R\u000eM'A\u0004)s_\u000e,7o]\"sK\u0006$X\r\u001a\u0006\u0004\u0007\u001bl\u0016aC<ji\"\u0004&o\\2fgN,Ba!7\u0004fR!11\u001cC\u0002)\u0011\u0019ina;\u0015\t\r}7\u0011\u001e\t\u0005M&\u001c\t\u000f\u0005\u0004\u0002,\u0006E61\u001d\t\u0005\u0005G\u001a)\u000fB\u0004\u0004hv\u0011\rA!\u001b\u0003\u0003QCq!!\u001b\u001e\u0001\b\tY\u0007C\u0004\u0004fu\u0001\ra!<\u0011\u000fE\u001aIga<\u0004`B\"1\u0011_B{!\u0019\u0011)Fa\u0017\u0004tB!!1MB{\t1\u00199p!?\u0002\u0002\u0003\u0005)\u0011\u0001B5\u0005\ryF%\u000e\u0005\b\u0007Kj\u0002\u0019AB~!\u001d\t4\u0011NBx\u0007{\u0004BAZ5\u0004\u0000B1\u00111VAY\t\u0003\u0001BAa\u0019\u0004f\"9\u0011QP\u000fA\u0002\u0005}\u0014AF<ji\"tu\u000e^!sG\"Lg/\u001a3Qe>\u001cWm]:\u0016\t\u0011%AQ\u0003\u000b\u0007\t\u0017!\t\u0004b\r\u0015\t\u00115A\u0011\u0004\u000b\u0005\t\u001f!9\u0002\u0005\u0003gS\u0012E\u0001CBAV\u0003c#\u0019\u0002\u0005\u0003\u0003d\u0011UAaBBt=\t\u0007!\u0011\u000e\u0005\b\u0003Sr\u00029AA6\u0011\u001d\u0019)G\ba\u0001\t7\u0001r!MB5\t;!y\u0001\r\u0003\u0005 \u0011\r\u0002C\u0002B+\u00057\"\t\u0003\u0005\u0003\u0003d\u0011\rB\u0001\u0004C\u0013\tO\t\t\u0011!A\u0003\u0002\t%$aA0%m!91Q\r\u0010A\u0002\u0011%\u0002cB\u0019\u0004j\u0011uA1\u0006\t\u0005M&$i\u0003\u0005\u0004\u0002,\u0006EFq\u0006\t\u0005\u0005G\")\u0002C\u0004\u0002~y\u0001\r!a \t\u000f\u0011Ub\u00041\u0001\u0002~\u0006aQM\u001d:pe6+7o]1hKV!A\u0011\bC#)\u0019!Y\u0004\"\u0019\u0005dQ!AQ\bC%)\u0011!y\u0004b\u0012\u0011\t\u0019LG\u0011\t\t\u0007\u0003W\u000b\t\fb\u0011\u0011\t\t\rDQ\t\u0003\b\u0007O|\"\u0019\u0001B5\u0011\u001d\tIg\ba\u0002\u0003WBqa!\u001a \u0001\u0004!Y\u0005E\u00042\u0007S\"i\u0005b\u00101\t\u0011=C1\u000b\t\u0007\u0005+\u0012Y\u0006\"\u0015\u0011\t\t\rD1\u000b\u0003\r\t+\"9&!A\u0001\u0002\u000b\u0005!\u0011\u000e\u0002\u0004?\u0012:\u0004bBB3?\u0001\u0007A\u0011\f\t\bc\r%DQ\nC.!\u00111\u0017\u000e\"\u0018\u0011\r\u0005-\u0016\u0011\u0017C0!\u0011\u0011\u0019\u0007\"\u0012\t\u000f\u0005ut\u00041\u0001\u0002\u0000!9!qH\u0010A\u0002\r\u001d\u0015aE<ji\"tu\u000e\u001e*v]:LgnZ*uCR,W\u0003\u0002C5\tk\"b\u0001b\u001b\u0005\u0006\u0012EE\u0003\u0002C7\ts\"B\u0001b\u001c\u0005xA!a-\u001bC9!\u0019\tY+!-\u0005tA!!1\rC;\t\u001d\u00199\u000f\tb\u0001\u0005SBq!!\u001b!\u0001\b\tY\u0007C\u0004\u0004f\u0001\u0002\r\u0001b\u001f\u0011\u000fE\u001aI\u0007\" \u0005pA!Aq\u0010CA\u001b\t\u0019Y*\u0003\u0003\u0005\u0004\u000em%\u0001\u0004)s_\u000e,7o]*uCR,\u0007BB\u0013!\u0001\u0004!9\t\r\u0003\u0005\n\u00125\u0005C\u0002B+\u00057\"Y\t\u0005\u0003\u0003d\u00115E\u0001\u0004CH\t\u000b\u000b\t\u0011!A\u0003\u0002\t%$aA0%q!9AQ\u0007\u0011A\u0002\u0005u\u0018AE<ji\"\u0004&o\\2fgNLgn\u001a+za\u0016,B\u0001b&\u0005.R!A\u0011\u0014CZ)\u0011!Y\nb,\u0011\t\u0019LGQ\u0014\t\t\u0005##y\nb)\u0005,&!A\u0011\u0015BO\u0005\u0019)\u0015\u000e\u001e5feB!AQ\u0015CT\u001b\u00051\u0013b\u0001CUM\tAQi\u001d9FeJ|'\u000f\u0005\u0003\u0003d\u00115FaBBtC\t\u0007!\u0011\u000e\u0005\b\u0007K\n\u0003\u0019\u0001CY!\u001d\t4\u0011\u000eBx\t7Cq!a?\"\u0001\u0004\ti0\u0006\u0003\u00058\u0012\rGC\u0002C]\t\u0017$i\r\u0006\u0003\u0005<\u0012\u0015\u0007\u0003\u00024j\t{\u0003bA!%\u0003\u001a\u0012}\u0006C\u0002B+\u00057\"\t\r\u0005\u0003\u0003d\u0011\rGa\u0002B4E\t\u0007!\u0011\u000e\u0005\n\t\u000f\u0014\u0013\u0011!a\u0002\t\u0013\f!\"\u001a<jI\u0016t7-\u001a\u00138!\u0019\u0011)F! \u0005B\"9\u0011\u0011\u000e\u0012A\u0002\u0005-\u0004b\u0002ChE\u0001\u0007A\u0011[\u0001\u000bSN\f%o\u00195jm\u0016$\u0007cA\u0019\u0005T&\u0019AQ\u001b\u001a\u0003\u000f\t{w\u000e\\3b]\u0002")
public class DBProcessService
implements ProcessService,
LazyLogging {
    private final DeploymentService deploymentService;
    private final NewProcessPreparer newProcessPreparer;
    private final ProcessCategoryService processCategoryService;
    private final UIProcessResolving processResolving;
    private final DBIOActionRunner dbioRunner;
    private final FetchingProcessRepository<Future> fetchingProcessRepository;
    private final ProcessActionRepository<DBIOAction> processActionRepository;
    private final ProcessRepository<DBIOAction> processRepository;
    private final ProcessValidation processValidation;
    private final ExecutionContext ec;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    private Logger logger$lzycompute() {
        DBProcessService dBProcessService = this;
        synchronized (dBProcessService) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$trans$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public Future<Either<EspError, BoxedUnit>> archiveProcess(ProcessIdWithName processIdWithName, LoggedUser user) {
        return this.withNotArchivedProcess(processIdWithName, ProcessActionType$.MODULE$.Archive(), (Function1 & Serializable & scala.Serializable)process2 -> process2.isSubprocess() ? this.archiveSubprocess((processdetails.BaseProcessDetails<?>)process2, user) : this.doOnProcessStateVerification((processdetails.BaseProcessDetails<?>)process2, ProcessActionType$.MODULE$.Archive(), (Function1 & Serializable & scala.Serializable)process -> this.doArchive((processdetails.BaseProcessDetails<?>)process, user), user), user);
    }

    @Override
    public Future<Either<EspError, BoxedUnit>> unArchiveProcess(ProcessIdWithName processIdWithName, LoggedUser user) {
        return this.withProcess(processIdWithName, (Function1 & Serializable & scala.Serializable)process -> process.isArchived() ? $this.dbioRunner.runInTransaction(DBIOAction$.MODULE$.seq((Seq)Predef$.MODULE$.wrapRefArray((Object[])new DBIOAction[]{$this.processRepository.archive(process.idWithName().id(), false), $this.processActionRepository.markProcessAsUnArchived(process.idWithName().id(), process.processVersionId(), user)}))).map((Function1 & Serializable & scala.Serializable)x$1 -> EitherIdOps$.MODULE$.asRight$extension(package.either$.MODULE$.catsSyntaxEitherId((Object)BoxedUnit.UNIT)), $this.ec) : Future$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> package$.MODULE$.Left().apply((Object)new ProcessIllegalAction("Can't unarchive not archived scenario.")), $this.ec), user);
    }

    @Override
    public Future<Either<EspError, BoxedUnit>> deleteProcess(ProcessIdWithName processIdWithName, LoggedUser user) {
        return this.withProcess(processIdWithName, (Function1 & Serializable & scala.Serializable)process -> this.withNotRunningState((processdetails.BaseProcessDetails<?>)process, "Can't delete still running scenario.", (Function1 & Serializable & scala.Serializable)x$2 -> $this.dbioRunner.runInTransaction($this.processRepository.deleteProcess(processIdWithName.id())).map((Function1 & Serializable & scala.Serializable)x$3 -> EitherIdOps$.MODULE$.asRight$extension(package.either$.MODULE$.catsSyntaxEitherId((Object)BoxedUnit.UNIT)), $this.ec), user), user);
    }

    @Override
    public Future<Either<EspError, package.UpdateProcessNameResponse>> renameProcess(ProcessIdWithName processIdWithName, ProcessName name, LoggedUser user) {
        return this.withNotArchivedProcess(processIdWithName, "Can't rename archived scenario.", (Function1 & Serializable & scala.Serializable)process -> this.withNotRunningState((processdetails.BaseProcessDetails<?>)process, "Can't change name still running scenario.", (Function1 & Serializable & scala.Serializable)x$4 -> $this.dbioRunner.runInTransaction($this.processRepository.renameProcess(processIdWithName, name, user).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Right right;
            Either either = x0$1;
            if (either instanceof Right) {
                right = package$.MODULE$.Right().apply((Object)package.UpdateProcessNameResponse$.MODULE$.create(process.name(), name.value()));
            } else if (either instanceof Left) {
                Left left = (Left)either;
                EspError value = (EspError)left.value();
                right = package$.MODULE$.Left().apply((Object)value);
            } else {
                throw new MatchError((Object)either);
            }
            return right;
        }, $this.ec)), user), user);
    }

    @Override
    public Future<Either<EspError, package.UpdateProcessCategoryResponse>> updateCategory(ProcessIdWithName processIdWithName, String category, LoggedUser user) {
        return this.withNotArchivedProcess(processIdWithName, "Can't update category archived scenario.", (Function1 & Serializable & scala.Serializable)process -> this.withProcessingType(category, (Function1 & Serializable & scala.Serializable)x$5 -> $this.dbioRunner.runInTransaction($this.processRepository.updateCategory(processIdWithName.id(), category, user).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Right right;
            Either either = x0$1;
            if (either instanceof Right) {
                right = package$.MODULE$.Right().apply((Object)new package.UpdateProcessCategoryResponse(process.processCategory(), category));
            } else if (either instanceof Left) {
                Left left = (Left)either;
                EspError value = (EspError)left.value();
                right = package$.MODULE$.Left().apply((Object)value);
            } else {
                throw new MatchError((Object)either);
            }
            return right;
        }, $this.ec))), user);
    }

    @Override
    public Future<Either<EspError, package.ProcessResponse>> createProcess(ProcessService.CreateProcessCommand command, LoggedUser user) {
        return this.withProcessingType(command.category(), (Function1 & Serializable & scala.Serializable)processingType -> {
            CanonicalProcess emptyCanonicalProcess = $this.newProcessPreparer.prepareEmptyProcess(command.processName().value(), (String)processingType, command.isSubprocess());
            ProcessRepository.CreateProcessAction action = new ProcessRepository.CreateProcessAction(command.processName(), command.category(), emptyCanonicalProcess, (String)processingType, command.isSubprocess());
            List<ValidationResults.NodeValidationError> propertiesErrors = this.validateInitialScenarioProperties(emptyCanonicalProcess, (String)processingType, command.category());
            return propertiesErrors.nonEmpty() ? Future$.MODULE$.successful((Object)package$.MODULE$.Left().apply((Object)new ProcessValidationError(((TraversableOnce)propertiesErrors.map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.message(), List$.MODULE$.canBuildFrom())).mkString(", ")))) : $this.dbioRunner.runInTransaction($this.processRepository.saveNewProcess(action, user)).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Either either;
                Either either2 = x0$1;
                if (either2 instanceof Right) {
                    Right right = (Right)either2;
                    Option maybemaybeCreated = (Option)right.value();
                    either = (Either)maybemaybeCreated.map((Function1 & Serializable & scala.Serializable)created -> package$.MODULE$.Right().apply((Object)this.toProcessResponse(command.processName(), (ProcessRepository.ProcessCreated)created))).getOrElse((Function0 & Serializable & scala.Serializable)() -> package$.MODULE$.Left().apply((Object)new ProcessValidationError("Unknown error on creating scenario.")));
                } else if (either2 instanceof Left) {
                    Left left = (Left)either2;
                    EspError value = (EspError)left.value();
                    either = package$.MODULE$.Left().apply((Object)value);
                } else {
                    throw new MatchError((Object)either2);
                }
                return either;
            }, $this.ec);
        });
    }

    @Override
    public Future<Either<EspError, package.UpdateProcessResponse>> updateProcess(ProcessIdWithName processIdWithName, ProcessService.UpdateProcessCommand action, LoggedUser user) {
        return this.withNotArchivedProcess(processIdWithName, "Can't update graph archived scenario.", (Function1 & Serializable & scala.Serializable)process -> {
            EitherT result = EitherT.FromEitherPartiallyApplied$.MODULE$.apply$extension(EitherT$.MODULE$.fromEither(), FatalValidationError$.MODULE$.saveNotAllowedAsError($this.processResolving.validateBeforeUiResolving(action.process())), (Applicative)package.future$.MODULE$.catsStdInstancesForFuture($this.ec)).map((Function1 & Serializable & scala.Serializable)validation -> {
                CanonicalProcess substituted = $this.processResolving.resolveExpressions(action.process(), (Map<String, Map<String, ExpressionTypingInfo>>)validation.typingInfo());
                return new Tuple2(validation, (Object)substituted);
            }, (Functor)package.future$.MODULE$.catsStdInstancesForFuture($this.ec)).flatMap((Function1 & Serializable & scala.Serializable)x$9 -> {
                Tuple2 tuple2 = x$9;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                ValidationResults.ValidationResult validation = (ValidationResults.ValidationResult)tuple2._1();
                CanonicalProcess substituted = (CanonicalProcess)tuple2._2();
                EitherT eitherT = new EitherT($this.dbioRunner.runInTransaction($this.processRepository.updateProcess(new ProcessRepository.UpdateProcessAction(processIdWithName.id(), substituted, (Option<Comment>)Option$.MODULE$.apply((Object)action.comment()), false), user))).map((Function1 & Serializable & scala.Serializable)processUpdated -> new package.UpdateProcessResponse(processUpdated.newVersion().map((Function1 & Serializable & scala.Serializable)x$7 -> new ProcessRepository.ProcessCreated(processIdWithName.id(), (VersionId)x$7)).map((Function1 & Serializable & scala.Serializable)x$8 -> this.toProcessResponse(processIdWithName.name(), (ProcessRepository.ProcessCreated)x$8)), validation), (Functor)package.future$.MODULE$.catsStdInstancesForFuture($this.ec));
                return eitherT;
            }, (Monad)package.future$.MODULE$.catsStdInstancesForFuture($this.ec));
            return (Future)result.value();
        }, user);
    }

    @Override
    public <PS> Future<Either<EspError, processdetails.BaseProcessDetails<PS>>> getProcess(ProcessIdWithName processIdWithName, processdetails.ProcessShapeFetchStrategy<PS> evidence$4, LoggedUser user) {
        return this.fetchingProcessRepository.fetchLatestProcessDetailsForProcessId(processIdWithName.id(), evidence$4, user, this.ec).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Future future;
            Option option = x0$1;
            if (option instanceof Some) {
                Some some = (Some)option;
                processdetails.BaseProcessDetails process = (processdetails.BaseProcessDetails)some.value();
                future = Future$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> package$.MODULE$.Right().apply((Object)process), $this.ec);
            } else if (None$.MODULE$.equals(option)) {
                future = Future$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> package$.MODULE$.Left().apply((Object)new ProcessDBQueryRepository.ProcessNotFoundError(((Object)BoxesRunTime.boxToLong((long)processIdWithName.id().value())).toString())), $this.ec);
            } else {
                throw new MatchError((Object)option);
            }
            return future;
        }, this.ec);
    }

    @Override
    public <PS> Future<List<processdetails.BaseProcessDetails<PS>>> getProcesses(LoggedUser user, processdetails.ProcessShapeFetchStrategy<PS> evidence$5) {
        return this.getProcesses(user, false, evidence$5);
    }

    @Override
    public <PS> Future<List<processdetails.BaseProcessDetails<PS>>> getArchivedProcesses(LoggedUser user, processdetails.ProcessShapeFetchStrategy<PS> evidence$6) {
        return this.getProcesses(user, true, evidence$6);
    }

    @Override
    public Future<Set<SubprocessDetails>> getSubProcesses(Option<List<String>> processingTypes, LoggedUser user) {
        Some x$1 = new Some((Object)BoxesRunTime.boxToBoolean((boolean)true));
        Some x$2 = new Some((Object)BoxesRunTime.boxToBoolean((boolean)false));
        Option<List<String>> x$3 = processingTypes;
        Option<Object> x$4 = FetchingProcessRepository$FetchProcessesDetailsQuery$.MODULE$.apply$default$3();
        Option<Seq<String>> x$5 = FetchingProcessRepository$FetchProcessesDetailsQuery$.MODULE$.apply$default$4();
        Option<Seq<ProcessName>> x$6 = FetchingProcessRepository$FetchProcessesDetailsQuery$.MODULE$.apply$default$6();
        return this.fetchingProcessRepository.fetchProcessesDetails(new FetchingProcessRepository.FetchProcessesDetailsQuery((Option<Object>)x$1, (Option<Object>)x$2, x$4, x$5, x$3, x$6), processdetails.ProcessShapeFetchStrategy$.FetchCanonical$.MODULE$, user, this.ec).map((Function1 & Serializable & scala.Serializable)processes -> ((TraversableOnce)processes.map((Function1 & Serializable & scala.Serializable)sub -> new SubprocessDetails((CanonicalProcess)sub.json(), sub.processCategory()), List$.MODULE$.canBuildFrom())).toSet(), this.ec);
    }

    @Override
    public Future<Either<EspError, ValidatedDisplayableProcess>> importProcess(ProcessIdWithName processId, String jsonString, LoggedUser user) {
        return this.withNotArchivedProcess(processId, "Import is not allowed for archived process.", (Function1 & Serializable & scala.Serializable)process -> {
            Either result = ProcessMarshaller$.MODULE$.fromJson(jsonString).leftMap((Function1)ProcessesResources$UnmarshallError$.MODULE$).toEither().map((Function1 & Serializable & scala.Serializable)jsonCanonicalProcess -> {
                CanonicalProcess canonical = jsonCanonicalProcess.withProcessId(processId.name());
                DisplayableProcess displayable = ProcessConverter$.MODULE$.toDisplayable(canonical, process.processingType(), process.processCategory());
                ValidationResults.ValidationResult validationResult = $this.processResolving.validateBeforeUiReverseResolving(canonical, displayable.processingType(), process.processCategory());
                return new ValidatedDisplayableProcess(displayable, validationResult);
            });
            return Future$.MODULE$.successful((Object)result);
        }, user);
    }

    private List<ValidationResults.NodeValidationError> validateInitialScenarioProperties(CanonicalProcess canonicalProcess, String processingType, String category) {
        ValidationResults.ValidationResult validationResult = this.processValidation.processingTypeValidationWithTypingInfo(canonicalProcess, processingType, category);
        return validationResult.errors().processPropertiesErrors();
    }

    private Future<Either<EspError, BoxedUnit>> archiveSubprocess(processdetails.BaseProcessDetails<?> process, LoggedUser user) {
        return this.doArchive(process, user);
    }

    private Future<Either<EspError, BoxedUnit>> doOnProcessStateVerification(processdetails.BaseProcessDetails<?> process, Enumeration.Value actionToCheck, Function1<processdetails.BaseProcessDetails<?>, Future<Either<EspError, BoxedUnit>>> callback, LoggedUser user) {
        return this.deploymentService.getProcessState(process.idWithName(), user, this.ec).flatMap((Function1 & Serializable & scala.Serializable)state -> state.allowedActions().contains((Object)actionToCheck) ? (Future)callback.apply((Object)process) : Future$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> package$.MODULE$.Left().apply((Object)ProcessIllegalAction$.MODULE$.apply(actionToCheck, process.idWithName(), (ProcessState)state)), $this.ec), this.ec);
    }

    private Future<Either<EspError, BoxedUnit>> doArchive(processdetails.BaseProcessDetails<?> process, LoggedUser user) {
        return this.dbioRunner.runInTransaction(DBIOAction$.MODULE$.seq((Seq)Predef$.MODULE$.wrapRefArray((Object[])new DBIOAction[]{this.processRepository.archive(process.idWithName().id(), true), this.processActionRepository.markProcessAsArchived(process.idWithName().id(), process.processVersionId(), user)}))).map((Function1 & Serializable & scala.Serializable)x$10 -> EitherIdOps$.MODULE$.asRight$extension(package.either$.MODULE$.catsSyntaxEitherId((Object)BoxedUnit.UNIT)), this.ec);
    }

    private package.ProcessResponse toProcessResponse(ProcessName processName, ProcessRepository.ProcessCreated created) {
        return new package.ProcessResponse(created.processId(), created.processVersionId(), processName);
    }

    private <T> Future<Either<EspError, T>> withProcess(ProcessIdWithName processIdWithName, Function1<processdetails.BaseProcessDetails<?>, Future<Either<EspError, T>>> callback, LoggedUser user) {
        return this.getProcess(processIdWithName, (processdetails.ProcessShapeFetchStrategy)processdetails.ProcessShapeFetchStrategy$.NotFetch$.MODULE$, user).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Future future;
            Either either = x0$1;
            if (either instanceof Left) {
                Left left = (Left)either;
                EspError err = (EspError)left.value();
                future = Future$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> package$.MODULE$.Left().apply((Object)err), $this.ec);
            } else if (either instanceof Right) {
                Right right = (Right)either;
                processdetails.BaseProcessDetails t = (processdetails.BaseProcessDetails)right.value();
                future = (Future)callback.apply((Object)t);
            } else {
                throw new MatchError((Object)either);
            }
            return future;
        }, this.ec);
    }

    private <T> Future<Either<EspError, T>> withNotArchivedProcess(ProcessIdWithName processIdWithName, String errorMessage, Function1<processdetails.BaseProcessDetails<?>, Future<Either<EspError, T>>> callback, LoggedUser user) {
        return this.withProcess(processIdWithName, (Function1 & Serializable & scala.Serializable)process -> process.isArchived() ? Future$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> package$.MODULE$.Left().apply((Object)new ProcessIllegalAction(errorMessage)), $this.ec) : (Future)callback.apply(process), user);
    }

    private <T> Future<Either<EspError, T>> withNotArchivedProcess(ProcessIdWithName processIdWithName, Enumeration.Value action, Function1<processdetails.BaseProcessDetails<?>, Future<Either<EspError, T>>> callback, LoggedUser user) {
        return this.withProcess(processIdWithName, (Function1 & Serializable & scala.Serializable)process -> process.isArchived() ? Future$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> package$.MODULE$.Left().apply((Object)ProcessIllegalAction$.MODULE$.archived(action, process.idWithName())), $this.ec) : (Future)callback.apply(process), user);
    }

    private <T> Future<Either<EspError, T>> withNotRunningState(processdetails.BaseProcessDetails<?> process, String errorMessage, Function1<ProcessState, Future<Either<EspError, T>>> callback, LoggedUser user) {
        return process.isDeployed() ? Future$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> package$.MODULE$.Left().apply((Object)new ProcessIllegalAction(errorMessage)), this.ec) : this.deploymentService.getProcessState(process.idWithName(), user, this.ec).flatMap((Function1 & Serializable & scala.Serializable)ps -> ps.status().isRunning() ? Future$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> package$.MODULE$.Left().apply((Object)new ProcessIllegalAction(errorMessage)), $this.ec) : (Future)callback.apply(ps), this.ec);
    }

    private <T> Future<Either<EspError, T>> withProcessingType(String category, Function1<String, Future<Either<EspError, T>>> callback) {
        Future future;
        Option<String> option = this.processCategoryService.getTypeForCategory(category);
        if (option instanceof Some) {
            Some some = (Some)option;
            String processingType = (String)some.value();
            future = (Future)callback.apply((Object)processingType);
        } else if (None$.MODULE$.equals(option)) {
            future = Future$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> package$.MODULE$.Left().apply((Object)new ProcessValidationError("Scenario category not found.")), this.ec);
        } else {
            throw new MatchError(option);
        }
        return future;
    }

    private <PS> Future<List<processdetails.BaseProcessDetails<PS>>> getProcesses(LoggedUser user, boolean isArchived, processdetails.ProcessShapeFetchStrategy<PS> evidence$7) {
        List<String> userCategories = this.processCategoryService.getUserCategories(user);
        processdetails.ProcessShapeFetchStrategy shapeStrategy = (processdetails.ProcessShapeFetchStrategy)Predef$.MODULE$.implicitly(evidence$7);
        Some x$1 = new Some((Object)BoxesRunTime.boxToBoolean((boolean)isArchived));
        Some x$2 = new Some(userCategories);
        Option<Object> x$3 = FetchingProcessRepository$FetchProcessesDetailsQuery$.MODULE$.apply$default$1();
        Option<Object> x$4 = FetchingProcessRepository$FetchProcessesDetailsQuery$.MODULE$.apply$default$3();
        Option<Seq<String>> x$5 = FetchingProcessRepository$FetchProcessesDetailsQuery$.MODULE$.apply$default$5();
        Option<Seq<ProcessName>> x$6 = FetchingProcessRepository$FetchProcessesDetailsQuery$.MODULE$.apply$default$6();
        return this.fetchingProcessRepository.fetchProcessesDetails(new FetchingProcessRepository.FetchProcessesDetailsQuery(x$3, (Option<Object>)x$1, x$4, (Option<Seq<String>>)x$2, x$5, x$6), shapeStrategy, user, this.ec);
    }

    public DBProcessService(DeploymentService deploymentService, NewProcessPreparer newProcessPreparer, ProcessCategoryService processCategoryService, UIProcessResolving processResolving, DBIOActionRunner dbioRunner, FetchingProcessRepository<Future> fetchingProcessRepository, ProcessActionRepository<DBIOAction> processActionRepository, ProcessRepository<DBIOAction> processRepository, ProcessValidation processValidation, ExecutionContext ec) {
        this.deploymentService = deploymentService;
        this.newProcessPreparer = newProcessPreparer;
        this.processCategoryService = processCategoryService;
        this.processResolving = processResolving;
        this.dbioRunner = dbioRunner;
        this.fetchingProcessRepository = fetchingProcessRepository;
        this.processActionRepository = processActionRepository;
        this.processRepository = processRepository;
        this.processValidation = processValidation;
        this.ec = ec;
        LazyLogging.$init$((LazyLogging)this);
    }
}

